/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.gcse;

import de.gaalop.StringList;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.cfgImport.optimization.gcse.Index;
import java.util.Collection;
import java.util.LinkedList;

public class IndexCreator
extends EmptyControlFlowVisitor
implements ExpressionVisitor {
    private SequentialNode curNode;
    private final Index index = new Index();
    private StringList curPattern;

    public static Index createIndex(ControlFlowGraph graph) {
        LinkedList hashExpressions = new LinkedList();
        IndexCreator visitor = new IndexCreator();
        graph.accept((ControlFlowVisitor)visitor);
        return visitor.index;
    }

    public void visit(AssignmentNode node) {
        this.curNode = node;
        node.getValue().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getValue(), this.curPattern, this.curNode, node.getVariable());
        this.curPattern = null;
        super.visit(node);
    }

    public void visit(ExpressionStatement node) {
        this.curNode = node;
        node.getExpression().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getExpression(), this.curPattern, this.curNode, null);
        this.curPattern = null;
        super.visit(node);
    }

    public void visit(ColorNode node) {
        this.curNode = node;
        node.getR().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getR(), this.curPattern, this.curNode, null);
        node.getG().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getG(), this.curPattern, this.curNode, null);
        node.getB().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getB(), this.curPattern, this.curNode, null);
        node.getAlpha().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getAlpha(), this.curPattern, this.curNode, null);
        super.visit(node);
    }

    public void visit(Addition node) {
        node.getLeft().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getLeft(), this.curPattern, this.curNode, null);
        StringList leftPattern = this.curPattern;
        this.curPattern = null;
        node.getRight().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getRight(), this.curPattern, this.curNode, null);
        this.curPattern.addAll((Collection)leftPattern);
        this.curPattern.add((Object)"+");
    }

    public void visit(Subtraction node) {
        node.getLeft().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getLeft(), this.curPattern, this.curNode, null);
        StringList leftPattern = this.curPattern;
        this.curPattern = null;
        node.getRight().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getRight(), this.curPattern, this.curNode, null);
        this.curPattern.addAll((Collection)leftPattern);
        this.curPattern.add((Object)"-");
    }

    public void visit(Division node) {
        node.getLeft().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getLeft(), this.curPattern, this.curNode, null);
        StringList leftPattern = this.curPattern;
        this.curPattern = null;
        node.getRight().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getRight(), this.curPattern, this.curNode, null);
        this.curPattern.addAll((Collection)leftPattern);
        this.curPattern.add((Object)"/");
    }

    public void visit(Multiplication node) {
        node.getLeft().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getLeft(), this.curPattern, this.curNode, null);
        StringList leftPattern = this.curPattern;
        this.curPattern = null;
        node.getRight().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getRight(), this.curPattern, this.curNode, null);
        this.curPattern.addAll((Collection)leftPattern);
        this.curPattern.add((Object)"*");
    }

    public void visit(Exponentiation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getLeft(), this.curPattern, this.curNode, null);
        StringList leftPattern = this.curPattern;
        this.curPattern = null;
        node.getRight().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getRight(), this.curPattern, this.curNode, null);
        this.curPattern.addAll((Collection)leftPattern);
        this.curPattern.add((Object)"^^");
    }

    public void visit(MathFunctionCall node) {
        node.getOperand().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getOperand(), this.curPattern, this.curNode, null);
        this.curPattern.add((Object)node.getFunction().name());
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        this.index.indexExpression(node.getOperand(), this.curPattern, this.curNode, null);
        this.curPattern.add((Object)"NEG");
    }

    public void visit(Variable node) {
        this.curPattern = new StringList();
        this.curPattern.add((Object)node.getName());
    }

    public void visit(MultivectorComponent node) {
        this.curPattern = new StringList();
        this.curPattern.add((Object)node.toString());
    }

    public void visit(FloatConstant node) {
        this.curPattern = new StringList();
        this.curPattern.add((Object)Double.toString(node.getValue()));
    }

    public void visit(InnerProduct node) {
        throw new IllegalStateException();
    }

    public void visit(OuterProduct node) {
        throw new IllegalStateException();
    }

    public void visit(BaseVector node) {
        throw new IllegalStateException();
    }

    public void visit(Reverse node) {
        throw new IllegalStateException();
    }

    public void visit(LogicalOr node) {
        throw new IllegalStateException();
    }

    public void visit(LogicalAnd node) {
        throw new IllegalStateException();
    }

    public void visit(LogicalNegation node) {
        throw new IllegalStateException();
    }

    public void visit(Equality node) {
        throw new IllegalStateException();
    }

    public void visit(Inequality node) {
        throw new IllegalStateException();
    }

    public void visit(Relation relation) {
        throw new IllegalStateException();
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException();
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException();
    }
}

