/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.maxima;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.dfg.Variable;

public class DFGToMaximaCode
implements ExpressionVisitor {
    private StringBuilder result = new StringBuilder();

    public String getResultString() {
        return this.result.toString();
    }

    private void handleUnary(UnaryOperation node, String operator) {
        this.result.append("(");
        this.result.append(operator);
        this.result.append("(");
        node.getOperand().accept((ExpressionVisitor)this);
        this.result.append("))");
    }

    private void handleBinary(BinaryOperation node, String operator) {
        this.result.append("(");
        node.getLeft().accept((ExpressionVisitor)this);
        this.result.append(operator);
        node.getRight().accept((ExpressionVisitor)this);
        this.result.append(")");
    }

    public void visit(Subtraction node) {
        this.handleBinary((BinaryOperation)node, "-");
    }

    public void visit(Addition node) {
        this.handleBinary((BinaryOperation)node, "+");
    }

    public void visit(Division node) {
        this.handleBinary((BinaryOperation)node, "/");
    }

    public void visit(InnerProduct node) {
        throw new IllegalStateException("Inner products should have been removed.");
    }

    public void visit(Multiplication node) {
        this.handleBinary((BinaryOperation)node, "*");
    }

    public void visit(MathFunctionCall node) {
        String opName = node.getFunction().name().toLowerCase();
        switch (node.getFunction()) {
            case CEIL: {
                opName = "ceiling";
                break;
            }
            case FACT: {
                opName = "";
                this.result.append("(");
                node.getOperand().accept((ExpressionVisitor)this);
                this.result.append("!)");
                return;
            }
        }
        this.handleUnary((UnaryOperation)node, opName);
    }

    public void visit(Variable node) {
        this.result.append(node.getName());
    }

    public void visit(MultivectorComponent node) {
        this.result.append(node.getName());
        this.result.append("\\$");
        this.result.append(node.getBladeIndex());
    }

    public void visit(Exponentiation node) {
        this.handleBinary((BinaryOperation)node, "^");
    }

    public void visit(FloatConstant node) {
        this.result.append(Double.toString(node.getValue()));
    }

    public void visit(OuterProduct node) {
        throw new IllegalStateException("Outer products should have been removed.");
    }

    public void visit(BaseVector node) {
        throw new IllegalStateException("BaseVectors should have been removed.");
    }

    public void visit(Negation node) {
        this.result.append("(");
        this.handleUnary((UnaryOperation)node, "-");
        this.result.append(")");
    }

    public void visit(Reverse node) {
        throw new IllegalStateException("Reverses should have been removed.");
    }

    public void visit(LogicalOr node) {
        this.handleBinary((BinaryOperation)node, " or ");
    }

    public void visit(LogicalAnd node) {
        this.handleBinary((BinaryOperation)node, " and ");
    }

    public void visit(LogicalNegation node) {
        this.handleUnary((UnaryOperation)node, "not ");
    }

    public void visit(Equality node) {
        this.result.append("equal(");
        node.getLeft().accept((ExpressionVisitor)this);
        this.result.append(",");
        node.getRight().accept((ExpressionVisitor)this);
        this.result.append(")");
    }

    public void visit(Inequality node) {
        this.result.append("notequal(");
        node.getLeft().accept((ExpressionVisitor)this);
        this.result.append(",");
        node.getRight().accept((ExpressionVisitor)this);
        this.result.append(")");
    }

    public void visit(Relation relation) {
        String operator = null;
        switch (relation.getType()) {
            case GREATER: {
                operator = ">";
                break;
            }
            case GREATER_OR_EQUAL: {
                operator = ">=";
                break;
            }
            case LESS: {
                operator = "<";
                break;
            }
            case LESS_OR_EQUAL: {
                operator = "<=";
            }
        }
        if (operator != null) {
            this.handleBinary((BinaryOperation)relation, operator);
        }
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("FunctionArguments should have been removed.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macros should have been removed.");
    }
}

