/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.maxima;

import de.gaalop.OptimizationException;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.tba.cfgImport.optimization.maxima.DFGToMaximaCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaximaInteractor {
    private final String commandMaxima;
    private Process process;
    private BufferedReader bufferedReader;
    private PrintWriter writer;

    public MaximaInteractor(String commandMaxima) {
        this.commandMaxima = commandMaxima;
    }

    public void openConnection() throws OptimizationException {
        try {
            ProcessBuilder builder = new ProcessBuilder(this.commandMaxima);
            this.process = builder.start();
            this.writer = new PrintWriter(this.process.getOutputStream());
            this.bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.initMaxima();
        }
        catch (Exception e) {
            this.process = null;
            this.bufferedReader = null;
            this.writer = null;
            throw new OptimizationException("Maxima is not accessible. Please check the Maxima command in the Configurations panel or disable the usage of Maxima optimization.", null);
        }
    }

    private void initMaxima() throws IOException {
        String line;
        this.writer.println("display2d:false;");
        this.writer.println("ratprint:false;");
        this.writer.println("keepfloat:true;");
        this.writer.println("5.653;");
        this.writer.flush();
        while (!(line = this.bufferedReader.readLine()).contains("5.653")) {
        }
    }

    public void closeConnection() {
        this.writer.println("quit();");
        this.writer.flush();
        try {
            this.process.waitFor(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(MaximaInteractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.process.isAlive()) {
            this.process.destroy();
        }
        this.process = null;
        this.bufferedReader = null;
        this.writer = null;
    }

    public boolean detectZeroExpression(Expression expr) throws IOException {
        String maximaOutput;
        if (this.process == null) {
            throw new IllegalStateException("Maxima connection is not open!");
        }
        DFGToMaximaCode dfgToMaximaCode = new DFGToMaximaCode();
        expr.accept((ExpressionVisitor)dfgToMaximaCode);
        String maximaInput = dfgToMaximaCode.getResultString();
        this.writer.println("is(equal(0," + maximaInput + "));");
        this.writer.flush();
        do {
            if (!(maximaOutput = this.bufferedReader.readLine()).startsWith("(%i")) continue;
            maximaOutput = this.bufferedReader.readLine();
        } while (!maximaOutput.startsWith("(%o"));
        return "true".equals(maximaOutput.substring(maximaOutput.indexOf(")") + 2).trim().toLowerCase());
    }
}

