/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.maxima;

import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.Multiplication;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaOutput;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaVisitor;
import de.gaalop.tba.cfgImport.optimization.maxima.parser.MaximaLexer;
import de.gaalop.tba.cfgImport.optimization.maxima.parser.MaximaParser;
import de.gaalop.visitors.ReplaceVisitor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MaximaRoutines {
    public static void groupMaximaInAndOutputs(LinkedList<String> connected, MaximaOutput output) {
        StringBuilder sb = new StringBuilder();
        boolean input = false;
        for (String o : output) {
            if (o.startsWith("(%i")) {
                input = false;
                if (sb.length() == 0) continue;
                connected.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (o.startsWith("(%o")) {
                sb.append(o.substring(o.indexOf(")") + 2));
                input = true;
                continue;
            }
            if (!input) continue;
            sb.append(o);
        }
        if (input && sb.length() > 0) {
            connected.add(sb.toString());
        }
    }

    public static Expression getExpressionFromMaximaOutput(String maximaOut) {
        try {
            ANTLRInputStream inputStream = new ANTLRInputStream((Reader)new StringReader(maximaOut));
            MaximaLexer lexer = new MaximaLexer((CharStream)inputStream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            MaximaParser parser = new MaximaParser((TokenStream)tokenStream);
            MaximaVisitor visitor = new MaximaVisitor();
            Expression expression = (Expression)visitor.visit((ParseTree)parser.expression());
            return MaximaRoutines.unfoldSimplePows(expression);
        }
        catch (IOException ex) {
            Logger.getLogger(MaximaRoutines.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static Expression unfoldSimplePows(Expression expression) {
        return new UnfoldingSimplePows().replace(expression);
    }

    private static class UnfoldingSimplePows
    extends ReplaceVisitor {
        private UnfoldingSimplePows() {
        }

        public void visit(Exponentiation node) {
            double constant;
            int integer;
            if (node.getRight() instanceof FloatConstant && (integer = (int)Math.round(constant = ((FloatConstant)node.getRight()).getValue())) > 0 && integer <= 3 && Math.abs(constant - (double)integer) < 1.0E-6) {
                switch (integer) {
                    case 1: {
                        this.result = node.getLeft();
                        return;
                    }
                    case 2: {
                        this.result = new Multiplication(node.getLeft(), node.getLeft());
                        return;
                    }
                    case 3: {
                        this.result = new Multiplication((Expression)new Multiplication(node.getLeft(), node.getLeft()), node.getLeft());
                        return;
                    }
                }
            }
            super.visit(node);
        }
    }
}

