/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.maxima;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.cfgImport.optimization.maxima.parser.MaximaBaseVisitor;
import de.gaalop.tba.cfgImport.optimization.maxima.parser.MaximaParser;
import org.antlr.v4.runtime.tree.ParseTree;

public class MaximaVisitor
extends MaximaBaseVisitor<Expression> {
    private Expression processFunction(String name, Expression arg) {
        for (MathFunction mathFunction : MathFunction.values()) {
            if (!mathFunction.toString().toLowerCase().equals(name)) continue;
            return new MathFunctionCall(arg, mathFunction);
        }
        throw new IllegalArgumentException("Function " + name + " is not supported by maxima parser");
    }

    @Override
    public Expression visitMv_coefficient(MaximaParser.Mv_coefficientContext ctx) {
        return new MultivectorComponent(ctx.name.getText(), Integer.parseInt(ctx.index.getText()));
    }

    @Override
    public Expression visitFunction(MaximaParser.FunctionContext ctx) {
        return this.processFunction(ctx.name.getText(), (Expression)this.visit((ParseTree)ctx.arg));
    }

    @Override
    public Expression visitExponentiation(MaximaParser.ExponentiationContext ctx) {
        return new Exponentiation((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Expression visitDivision(MaximaParser.DivisionContext ctx) {
        return new Division((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Expression visitVariable(MaximaParser.VariableContext ctx) {
        return new Variable(ctx.name.getText());
    }

    @Override
    public Expression visitNegation(MaximaParser.NegationContext ctx) {
        return new Negation((Expression)this.visit((ParseTree)ctx.operand));
    }

    @Override
    public Expression visitConstant(MaximaParser.ConstantContext ctx) {
        String text = ctx.getText();
        if ("%pi".equals(text)) {
            return new FloatConstant(Math.PI);
        }
        if ("%i".equals(text)) {
            return new MathFunctionCall((Expression)new FloatConstant(-1.0), MathFunction.SQRT);
        }
        return new FloatConstant(Double.parseDouble(text));
    }

    @Override
    public Expression visitSubtraction(MaximaParser.SubtractionContext ctx) {
        return new Subtraction((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Expression visitAddition(MaximaParser.AdditionContext ctx) {
        return new Addition((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Expression visitMultiplication(MaximaParser.MultiplicationContext ctx) {
        return new Multiplication((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Expression visitBracket(MaximaParser.BracketContext ctx) {
        return (Expression)this.visit((ParseTree)ctx.ex);
    }

    @Override
    public Expression visitNegationBracket(MaximaParser.NegationBracketContext ctx) {
        return new Negation((Expression)this.visit((ParseTree)ctx.operand));
    }
}

