/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.maxima;

import de.gaalop.LoggingListenerGroup;
import de.gaalop.OptimizationException;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaConnection;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaInput;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessBuilderMaximaConnection
implements MaximaConnection {
    public String commandMaxima;
    public static final String CMD_MAXIMA_WINDOWS = "C:\\Program Files (x86)\\Maxima-5.24.0\\bin\\maxima.bat";
    public static final String CMD_MAXIMA_LINUX = "/usr/bin/maxima";
    private LoggingListenerGroup listeners;

    public ProcessBuilderMaximaConnection(String commandMaxima) {
        this.commandMaxima = commandMaxima;
        if (this.commandMaxima.isEmpty()) {
            this.commandMaxima = ProcessBuilderMaximaConnection.findMaximaPath("C://");
        }
    }

    @Override
    public void setProgressListeners(LoggingListenerGroup progressListeners) {
        this.listeners = progressListeners;
    }

    @Override
    public MaximaOutput optimizeWithMaxima(MaximaInput input) throws OptimizationException {
        try {
            String line;
            Process p;
            File tmpFile = File.createTempFile("tbaMaxima", ".txt");
            PrintWriter out = new PrintWriter(tmpFile);
            for (String line2 : input) {
                out.println(line2);
            }
            out.close();
            MaximaOutput output = new MaximaOutput();
            String path = tmpFile.getCanonicalPath();
            if (File.separatorChar == '\\') {
                path = path.replaceAll("\\\\", "\\\\\\\\");
            }
            try {
                ProcessBuilder builder = new ProcessBuilder(this.commandMaxima);
                p = builder.start();
                PrintWriter writer = new PrintWriter(p.getOutputStream());
                writer.println("batch(\"" + path + "\");");
                writer.flush();
            }
            catch (Exception e) {
                tmpFile.delete();
                throw new OptimizationException("Maxima is not accessible. Please check the Maxima command in the Configurations panel or disable the usage of Maxima optimization.", null);
            }
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.listeners.logNote("Compiling with Maxima, please wait...", (Object)0.0);
            int lastPercent = 0;
            int progress = 0;
            while ((line = b.readLine()) != null) {
                int curPercent;
                String pattern = "[(][%]i\\d*[)].*";
                if (line.matches(pattern)) {
                    ++progress;
                }
                if (line.contains("quotient") && line.contains("zero")) {
                    Logger.getLogger(ProcessBuilderMaximaConnection.class.getName()).log(Level.INFO, "Quotient is zero. Aborting.");
                    return null;
                }
                int numSteps = input.size() + 1;
                if (numSteps <= 0) {
                    numSteps = 1;
                }
                if ((curPercent = progress * 100 / numSteps) >= lastPercent + 5) {
                    lastPercent = curPercent;
                    this.listeners.logNote("Compiling with Maxima, please wait...", (Object)((double)progress / (double)numSteps));
                }
                output.add(line);
            }
            this.listeners.logNote("Done", (Object)1.0);
            b.close();
            tmpFile.delete();
            return output;
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessBuilderMaximaConnection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static String findMaximaPath(String directoryPath) {
        File[] directories;
        File directory = new File(directoryPath);
        if (directory.isDirectory() && (directories = directory.listFiles(File::isDirectory)) != null) {
            for (File dir : directories) {
                Path maximaPath;
                if (!dir.getName().startsWith("maxima") || !Files.exists(maximaPath = Paths.get(dir.getAbsolutePath(), "bin", "maxima.bat"), new LinkOption[0])) continue;
                return maximaPath.toString();
            }
        }
        return "";
    }
}

