/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.table.BitIO;

import de.gaalop.tba.table.BitIO.AbsBitWriter;
import java.io.IOException;

public class MaxWriter
extends AbsBitWriter {
    private long cache = 0L;
    private int cachedBits = 0;

    @Override
    public void write(int data, int bitCount) throws IOException {
        this.cache <<= bitCount;
        long maskD = 0L;
        maskD ^= 0xFFFFFFFFFFFFFFFFL;
        maskD <<= bitCount;
        data = (int)((long)data & (maskD ^= 0xFFFFFFFFFFFFFFFFL));
        this.cache |= (long)data;
        this.cachedBits += bitCount;
        while (this.cachedBits >= 16) {
            this.writeCharFromCache();
        }
    }

    private void writeCharFromCache() throws IOException {
        long cacheT = this.cache;
        cacheT >>= this.cachedBits - 16;
        this.out.writeChar((int)(cacheT &= 0xFFFFL));
        long maskC = 0L;
        maskC ^= 0xFFFFFFFFFFFFFFFFL;
        maskC <<= this.cachedBits - 16;
        this.cache &= (maskC ^= 0xFFFFFFFFFFFFFFFFL);
        this.cachedBits -= 16;
    }

    @Override
    public void finish() throws IOException {
        if (this.cachedBits == 0) {
            return;
        }
        if (this.cachedBits != 16) {
            this.write(0, 16 - this.cachedBits);
        }
        this.writeCharFromCache();
    }
}

