/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.table;

import de.gaalop.tba.Blade;
import de.gaalop.tba.BladeRef;
import de.gaalop.tba.Multivector;
import java.util.Vector;

public class Parser {
    public static BladeRef parseBladeRef(String parse) {
        int prefactor = 1;
        int index = 0;
        String trimmed = parse.trim();
        if (trimmed.isEmpty() || trimmed.equals("0")) {
            prefactor = 0;
        } else if (trimmed.startsWith("-E")) {
            prefactor = -1;
            index = Integer.parseInt(trimmed.substring(2));
        } else if (trimmed.startsWith("E")) {
            index = Integer.parseInt(trimmed.substring(1));
        } else {
            String[] parts = trimmed.split("E");
            prefactor = (byte)Integer.parseInt(parts[0]);
            index = Integer.parseInt(parts[1]);
        }
        return new BladeRef((byte)prefactor, index);
    }

    public static Blade parseBlade(String parse) {
        String[] parts;
        Vector<String> bases = new Vector<String>();
        for (String part : parts = parse.split("\\^")) {
            bases.add(part.trim());
        }
        return new Blade(bases);
    }

    public static Multivector parseMultivector(String str) {
        String trimmed = str.trim();
        Multivector result = new Multivector();
        while (!trimmed.isEmpty()) {
            int index = -1;
            int indexPlus = -1;
            int indexMinus = -1;
            if (trimmed.charAt(0) == '-') {
                indexPlus = trimmed.indexOf(43, 1);
                indexMinus = trimmed.indexOf(45, 1);
            } else {
                indexPlus = trimmed.indexOf(43);
                indexMinus = trimmed.indexOf(45);
            }
            if (indexPlus == -1) {
                index = indexMinus == -1 ? -1 : indexMinus;
            } else {
                int n = index = indexMinus == -1 ? indexPlus : Math.min(indexMinus, indexPlus);
            }
            if (index == -1) {
                result.addBlade(Parser.parseBladeRef(trimmed));
                trimmed = "";
                continue;
            }
            result.addBlade(Parser.parseBladeRef(trimmed.substring(0, index)));
            if (trimmed.charAt(index) == '+') {
                trimmed = trimmed.substring(index + 1);
                continue;
            }
            trimmed = trimmed.substring(index);
        }
        return result;
    }
}

