/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.table;

import de.gaalop.tba.IMultTable;
import de.gaalop.tba.table.BitIO.AbsBitReader;
import de.gaalop.tba.table.BitIO.MaxReader;
import de.gaalop.tba.table.BitIO.MaxWriter;
import de.gaalop.tba.table.TableCompressed;
import de.gaalop.tba.table.TableHumanReadable;
import de.gaalop.tba.table.TableReaderIO;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TableFormat {
    public static final int TABLE_COMPRESSED_MAX = 1;
    public static final int TABLE_HUMAN_READABLE = 69;

    public static int getByteFormat(TableReaderIO tableReaderIO) {
        TableCompressed tc;
        AbsBitReader reader;
        if (tableReaderIO instanceof TableCompressed && (reader = (tc = (TableCompressed)tableReaderIO).getReader()) instanceof MaxReader) {
            return 1;
        }
        if (tableReaderIO instanceof TableHumanReadable) {
            return 69;
        }
        throw new IllegalArgumentException("Table_IO type unknown");
    }

    public static TableReaderIO getTableReaderIO(int byteFormat) {
        switch (byteFormat) {
            case 1: {
                return new TableCompressed(new MaxReader(), new MaxWriter());
            }
            case 69: {
                return new TableHumanReadable();
            }
        }
        throw new IllegalArgumentException("Products file format not recognized");
    }

    public static void readFromFile(InputStream filestream, IMultTable innerTable, IMultTable outerTable, IMultTable geoTable) throws IOException {
        DataInputStream in = new DataInputStream(filestream);
        byte format = in.readByte();
        TableFormat.getTableReaderIO(format).readFromInputStream(in, innerTable, outerTable, geoTable);
    }

    public static void writeToFile(int bladeCount, int dimension, IMultTable innerTable, IMultTable outerTable, IMultTable geoTable, OutputStream outputStream, int format) throws IOException {
        DataOutputStream out = new DataOutputStream(outputStream);
        out.writeByte(format);
        TableFormat.getTableReaderIO(format).writeFromInputStream(bladeCount, dimension, innerTable, outerTable, geoTable, out);
    }
}

