/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.table;

import de.gaalop.tba.BladeRef;
import de.gaalop.tba.IMultTable;
import de.gaalop.tba.table.Parser;
import de.gaalop.tba.table.TableCompressed;
import de.gaalop.tba.table.TableReaderIO;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TableHumanReadable
implements TableReaderIO {
    @Override
    public void readFromInputStream(DataInputStream filestream, IMultTable innerTable, IMultTable outerTable, IMultTable geoTable) {
        try {
            BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)filestream, Charset.forName("UTF-8")));
            long line = 0L;
            while (d.ready()) {
                String rest = d.readLine();
                if (line == 0L) {
                    rest = "E" + rest;
                }
                BladeRef ref0 = Parser.parseBladeRef(rest.substring(0, rest.indexOf(59)));
                rest = rest.substring(rest.indexOf(59) + 1);
                BladeRef ref1 = Parser.parseBladeRef(rest.substring(0, rest.indexOf(59)));
                rest = rest.substring(rest.indexOf(59) + 1);
                int index0 = ref0.getIndex();
                int index1 = ref1.getIndex();
                innerTable.setProduct(index0, index1, Parser.parseMultivector(rest.substring(0, rest.indexOf(59))));
                rest = rest.substring(rest.indexOf(59) + 1);
                outerTable.setProduct(index0, index1, Parser.parseMultivector(rest.substring(0, rest.indexOf(59))));
                rest = rest.substring(rest.indexOf(59) + 1);
                geoTable.setProduct(index0, index1, Parser.parseMultivector(rest));
                ++line;
            }
            d.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TableCompressed.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void writeFromInputStream(int bladeCount, int dimension, IMultTable innerTable, IMultTable outerTable, IMultTable geoTable, DataOutputStream outputStream) {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, Charset.forName("UTF-8")));
        long line = 0L;
        for (int i = 0; i < bladeCount; ++i) {
            for (int j = 0; j < bladeCount; ++j) {
                if (line != 0L) {
                    out.print("E");
                }
                out.print(i);
                out.print(";");
                out.print("E");
                out.print(j);
                out.print(";");
                out.print(innerTable.getProduct(i, j).print());
                out.print(";");
                out.print(outerTable.getProduct(i, j).print());
                out.print(";");
                out.print(geoTable.getProduct(i, j).print());
                out.println();
                ++line;
            }
        }
        out.close();
    }
}

