/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;

public class DFGDifferentiater
implements ExpressionVisitor {
    private MultivectorComponent diffVar;
    private Expression result;
    private final FloatConstant zero = new FloatConstant(0.0);

    private DFGDifferentiater(MultivectorComponent diffVar) {
        this.diffVar = diffVar;
    }

    public static Expression differentiate(Expression exp, MultivectorComponent diffVar) {
        DFGDifferentiater dFGDifferentiater = new DFGDifferentiater(diffVar);
        exp.accept((ExpressionVisitor)dFGDifferentiater);
        return dFGDifferentiater.result;
    }

    public void visit(Subtraction node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        if (left == this.zero) {
            if (this.result != this.zero) {
                this.result = new Negation(this.result);
            }
        } else {
            this.result = this.result == this.zero ? left : new Subtraction(left, this.result);
        }
    }

    public void visit(Addition node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        if (left != this.zero) {
            this.result = this.result == this.zero ? left : new Addition(left, this.result);
        }
    }

    public void visit(Division node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression dLeft = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression dRight = this.result;
        this.result = dLeft == this.zero ? (dRight == this.zero ? this.zero : new Negation((Expression)new Division((Expression)new Multiplication(node.getLeft().copy(), dRight), (Expression)new Multiplication(node.getRight().copy(), node.getRight().copy())))) : (dRight == this.zero ? new Division((Expression)new Multiplication(dLeft, node.getRight().copy()), (Expression)new Multiplication(node.getRight().copy(), node.getRight().copy())) : new Division((Expression)new Subtraction((Expression)new Multiplication(dLeft, node.getRight().copy()), (Expression)new Multiplication(node.getLeft().copy(), dRight)), (Expression)new Multiplication(node.getRight().copy(), node.getRight().copy())));
    }

    public void visit(Multiplication node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression dLeft = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression dRight = this.result;
        this.result = dLeft == this.zero ? (dRight == this.zero ? this.zero : new Multiplication(node.getLeft().copy(), dRight)) : (dRight == this.zero ? new Multiplication(dLeft, node.getRight().copy()) : new Addition((Expression)new Multiplication(dLeft, node.getRight().copy()), (Expression)new Multiplication(node.getLeft().copy(), dRight)));
    }

    public void visit(Exponentiation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression dLeft = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression dRight = this.result;
        if (dRight == this.zero) {
            Multiplication m = new Multiplication(node.getRight().copy(), (Expression)new Exponentiation(node.getLeft().copy(), (Expression)new Subtraction(node.getRight().copy(), (Expression)new FloatConstant(1.0))));
            this.result = dLeft == this.zero ? this.zero : new Multiplication((Expression)m, dLeft);
        } else if (dLeft == this.zero) {
            node.getRight().accept((ExpressionVisitor)this);
            Expression dv = this.result;
            this.result = new Multiplication((Expression)new Multiplication(dv, (Expression)new MathFunctionCall(node.getLeft().copy(), MathFunction.LOG)), node.copy());
        } else {
            node.getRight().accept((ExpressionVisitor)this);
            Expression dv = this.result;
            this.result = new Multiplication((Expression)new Addition((Expression)new Multiplication(dv, (Expression)new MathFunctionCall(node.getLeft().copy(), MathFunction.LOG)), (Expression)new Division((Expression)new Multiplication(node.getRight().copy(), dLeft), node.getLeft().copy())), node.copy());
        }
    }

    public void visit(MathFunctionCall node) {
        node.getOperand().accept((ExpressionVisitor)this);
        if (this.result != this.zero) {
            switch (node.getFunction()) {
                case ACOS: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    this.result = new Negation((Expression)new Division(this.result, (Expression)new MathFunctionCall((Expression)new Subtraction((Expression)new FloatConstant(1.0), (Expression)new Exponentiation(node.getOperand().copy(), (Expression)new FloatConstant(2.0))), MathFunction.SQRT)));
                    break;
                }
                case ASIN: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    this.result = new Division(this.result, (Expression)new MathFunctionCall((Expression)new Subtraction((Expression)new FloatConstant(1.0), (Expression)new Exponentiation(node.getOperand().copy(), (Expression)new FloatConstant(2.0))), MathFunction.SQRT));
                    break;
                }
                case ATAN: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    this.result = new Division(this.result, (Expression)new Addition((Expression)new FloatConstant(1.0), (Expression)new Exponentiation(node.getOperand().copy(), (Expression)new FloatConstant(2.0))));
                    break;
                }
                case COS: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    if (this.result == this.zero) break;
                    this.result = new Negation((Expression)new Multiplication((Expression)new MathFunctionCall(node.getOperand().copy(), MathFunction.SIN), this.result));
                    break;
                }
                case EXP: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    if (this.result == this.zero) break;
                    this.result = new Multiplication((Expression)new MathFunctionCall(node.getOperand().copy(), MathFunction.EXP), this.result);
                    break;
                }
                case LOG: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    if (this.result == this.zero) break;
                    this.result = new Division(this.result, node.getOperand().copy());
                    break;
                }
                case SIN: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    if (this.result == this.zero) break;
                    this.result = new Multiplication((Expression)new MathFunctionCall(node.getOperand().copy(), MathFunction.COS), this.result);
                    break;
                }
                case SQRT: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    if (this.result == this.zero) break;
                    this.result = new Division(this.result, (Expression)new Multiplication((Expression)new FloatConstant(2.0), (Expression)new MathFunctionCall(node.getOperand().copy(), MathFunction.SQRT)));
                    break;
                }
                case TAN: {
                    node.getOperand().accept((ExpressionVisitor)this);
                    if (this.result == this.zero) break;
                    this.result = new Division(this.result, (Expression)new Multiplication((Expression)new MathFunctionCall(node.getOperand().copy(), MathFunction.COS), (Expression)new MathFunctionCall(node.getOperand().copy(), MathFunction.COS)));
                }
            }
        }
    }

    public void visit(Variable node) {
        this.result = this.zero;
    }

    public void visit(MultivectorComponent node) {
        this.result = node.equals((Object)this.diffVar) ? new FloatConstant(1.0) : this.zero;
    }

    public void visit(FloatConstant node) {
        this.result = this.zero;
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        if (this.result != this.zero) {
            this.result = new Negation(this.result);
        }
    }

    public void visit(InnerProduct node) {
        throw new IllegalStateException("Inner products should have been removed by TBA");
    }

    public void visit(OuterProduct node) {
        throw new IllegalStateException("Outer products should have been removed by TBA");
    }

    public void visit(BaseVector node) {
        throw new IllegalStateException("Base vectors should have been removed by TBA");
    }

    public void visit(Reverse node) {
        throw new IllegalStateException("Reverses should have been removed by TBA");
    }

    public void visit(LogicalOr node) {
        throw new IllegalStateException("Logical ORs are not implemented yet");
    }

    public void visit(LogicalAnd node) {
        throw new IllegalStateException("Logical ANDs are not implemented yet");
    }

    public void visit(LogicalNegation node) {
        throw new IllegalStateException("Logical Negations are not implemented yet");
    }

    public void visit(Equality node) {
        throw new IllegalStateException("Equalities are not implemented yet");
    }

    public void visit(Inequality node) {
        throw new IllegalStateException("Inequalities are not implemented yet");
    }

    public void visit(Relation relation) {
        throw new IllegalStateException("Relations are not implemented yet");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("FunctionArguments should have been inlined by an Algebra plugin");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macro Calls should have been inlined by an Algebra plugin");
    }
}

