/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer;

import de.gaalop.LoggingListenerGroup;
import de.gaalop.OptimizationException;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.cfgImport.optimization.maxima.DFGToMaximaCode;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaInput;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaOutput;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaRoutines;
import de.gaalop.tba.cfgImport.optimization.maxima.ProcessBuilderMaximaConnection;
import de.gaalop.visualizer.Differentiater;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaximaDifferentiater
implements Differentiater {
    private String maximaCommand;

    public MaximaDifferentiater(String maximaCommand) {
        this.maximaCommand = maximaCommand;
    }

    @Override
    public LinkedList<AssignmentNode> differentiate(LinkedList<AssignmentNode> toDerive, MultivectorComponent variable) {
        try {
            ProcessBuilderMaximaConnection connection = new ProcessBuilderMaximaConnection(this.maximaCommand);
            connection.setProgressListeners(new LoggingListenerGroup());
            MaximaInput input = new MaximaInput();
            input.add((Object)"display2d:false;");
            input.add((Object)"ratprint:false;");
            input.add((Object)"keepfloat:true;");
            this.fillMaximaInput(toDerive, input, variable);
            input.add((Object)"quit();");
            MaximaOutput output = connection.optimizeWithMaxima(input);
            LinkedList connected = new LinkedList();
            MaximaRoutines.groupMaximaInAndOutputs(connected, (MaximaOutput)output);
            connected.removeFirst();
            connected.removeFirst();
            connected.removeFirst();
            LinkedList<AssignmentNode> result = new LinkedList<AssignmentNode>();
            ListIterator listIterator = toDerive.listIterator();
            for (String io : connected) {
                AssignmentNode node = (AssignmentNode)listIterator.next();
                Expression exp = MaximaRoutines.getExpressionFromMaximaOutput((String)io);
                result.add(new AssignmentNode(node.getGraph(), (Variable)new MultivectorComponent(node.getVariable().getName(), 0), exp));
            }
            return result;
        }
        catch (OptimizationException ex) {
            Logger.getLogger(MaximaDifferentiater.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void fillMaximaInput(LinkedList<AssignmentNode> toDerive, MaximaInput input, MultivectorComponent variable) {
        for (AssignmentNode node : toDerive) {
            DFGToMaximaCode dfg = new DFGToMaximaCode();
            node.getValue().accept((ExpressionVisitor)dfg);
            input.add((Object)("ratsimp(diff(" + dfg.getResultString() + "," + variable.getName() + "\\$" + variable.getBladeIndex() + ",1));"));
        }
    }
}

