/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorException;
import de.gaalop.OutputFile;
import de.gaalop.api.cfg.AssignmentNodeCollector;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.visitors.ReplaceVisitor;
import de.gaalop.visualizer.ColorEvaluater;
import de.gaalop.visualizer.Differentiater;
import de.gaalop.visualizer.DifferentiaterCreator;
import de.gaalop.visualizer.Point3d;
import de.gaalop.visualizer.PointCloud;
import de.gaalop.visualizer.PointClouds;
import de.gaalop.visualizer.Rendering;
import de.gaalop.visualizer.engines.lwjgl.RenderingEngine;
import de.gaalop.visualizer.engines.lwjgl.SimpleLwJglRenderingEngine;
import de.gaalop.visualizer.gui.DrawSettings;
import de.gaalop.visualizer.gui.InputsPanel;
import de.gaalop.visualizer.gui.SettingsPanel;
import de.gaalop.visualizer.gui.VisiblePanel;
import de.gaalop.visualizer.zerofinding.DiscreteCubeMethod;
import de.gaalop.visualizer.zerofinding.GradientMethod;
import de.gaalop.visualizer.zerofinding.RayMethod;
import de.gaalop.visualizer.zerofinding.ZeroFinder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;

public class NewDrawSettingsCodeGen
extends DrawSettings
implements CodeGenerator,
Rendering {
    private String lwJglNativePath;
    private LinkedList<AssignmentNode> graphAssignmentNodes;
    private Differentiater differentiater;
    public PointClouds loadedPointClouds = new PointClouds();
    private PointClouds computedPointClouds = new PointClouds();
    private InputsPanel inputsPanel;
    private SettingsPanel settingsPanel;
    private VisiblePanel visiblePanel;
    public HashMap<String, Color> colors;
    private RenderingEngine renderingEngine;
    private boolean newDataSetAvailable = false;
    private HashMap<String, Expression> renderingExpressions;
    private boolean renderIn2d;

    public NewDrawSettingsCodeGen(String lwJglNativePath) {
        this.lwJglNativePath = lwJglNativePath;
        this.jButton_Repaint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDrawSettingsCodeGen.this.recomputeCommand();
            }
        });
        this.inputsPanel = new InputsPanel(this.jPanel_Inputs){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (NewDrawSettingsCodeGen.this.settingsPanel.isAutoRendering()) {
                    NewDrawSettingsCodeGen.this.recomputeCommand();
                }
            }
        };
        this.settingsPanel = new SettingsPanel(this.jScrollPane_Settings, this.jPanel_Settings);
        this.visiblePanel = new VisiblePanel(this.jPanel_Visible){

            @Override
            public void stateChanged(ChangeEvent e) {
                NewDrawSettingsCodeGen.this.repaintCommand();
            }
        };
        this.jComboBox_ZerofindingMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDrawSettingsCodeGen.this.settingsPanel.setSettings(NewDrawSettingsCodeGen.this.getSelectedZeroFinder().getSettings());
                NewDrawSettingsCodeGen.this.repaint();
            }
        });
        this.jButton_DisplayEquations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = new JFrame("Gaalop - Rendering equations");
                frame.setLayout(new BorderLayout(5, 5));
                frame.setSize(500, 500);
                JScrollPane pane = new JScrollPane(20, 31);
                frame.add((Component)pane, "Center");
                JTextArea area = new JTextArea(NewDrawSettingsCodeGen.this.getDisplayEquationsAsString());
                area.setLineWrap(true);
                area.setEditable(false);
                pane.setViewportView(area);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
                JButton buttonCopy = new JButton("Copy content to clipboard");
                frame.add((Component)buttonCopy, "South");
                buttonCopy.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(new StringSelection(NewDrawSettingsCodeGen.this.getDisplayEquationsAsString()), null);
                    }
                });
            }
        });
        LinkedList<ZeroFinder> zerofinderList = new LinkedList<ZeroFinder>();
        GradientMethod defaultZeroFinder = new GradientMethod();
        zerofinderList.add(defaultZeroFinder);
        zerofinderList.add(new RayMethod());
        zerofinderList.add(new DiscreteCubeMethod());
        this.setZerofinderMethods(zerofinderList, defaultZeroFinder);
    }

    public Set<OutputFile> generate(ControlFlowGraph in) throws CodeGeneratorException {
        this.renderIn2d = "cr4d".equals(in.algebraName);
        this.renderingEngine = new SimpleLwJglRenderingEngine(this.lwJglNativePath, this);
        this.renderingEngine.start();
        AssignmentNodeCollector collector = new AssignmentNodeCollector();
        in.accept((ControlFlowVisitor)collector);
        this.graphAssignmentNodes = collector.getAssignmentNodes();
        this.differentiater = new DifferentiaterCreator(in.globalSettings.optMaxima, in.globalSettings.maximaCommand).createDifferentiater();
        this.renderingExpressions = in.getRenderingExpressions();
        this.colors = ColorEvaluater.getColors(in);
        LinkedList<String> inputs = new LinkedList<String>();
        for (Variable inputVar : in.getInputVariables()) {
            if (this.isPositionVariable(inputVar.getName())) continue;
            inputs.add(inputVar.getName());
        }
        Collections.sort(inputs);
        this.inputsPanel.setInputs(inputs);
        this.setVisible(true);
        this.setSize(this.getSize().width + 1, this.getSize().height);
        this.setSize(this.getSize().width - 1, this.getSize().height);
        return new HashSet<OutputFile>();
    }

    private void recomputeCommand() {
        this.computedPointClouds.clear();
        final ZeroFinder curZeroFinder = this.getSelectedZeroFinder();
        curZeroFinder.setDifferentiater(this.differentiater);
        this.jLabel_Info.setText("Please wait while rendering ...");
        this.jLabel_Info.repaint();
        final HashMap<MultivectorComponent, Double> globalValues = new HashMap<MultivectorComponent, Double>();
        HashMap<String, Double> inputValues = this.inputsPanel.getValues();
        for (String variable : inputValues.keySet()) {
            globalValues.put(new MultivectorComponent(variable, 0), inputValues.get(variable));
        }
        new Thread(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                LinkedList<AssignmentNode> list = new LinkedList<AssignmentNode>();
                for (AssignmentNode node : NewDrawSettingsCodeGen.this.graphAssignmentNodes) {
                    list.add(node.copyElements());
                }
                HashMap<String, LinkedList<Point3d>> pointsToRender = curZeroFinder.findZeroLocations(globalValues, list, NewDrawSettingsCodeGen.this.settingsPanel.getSettings(), NewDrawSettingsCodeGen.this.renderIn2d);
                long sum = 0L;
                for (String key : pointsToRender.keySet()) {
                    LinkedList<Point3d> points = pointsToRender.get(key);
                    sum += (long)points.size();
                    String myKey = key.endsWith("_S") ? key.substring(0, key.length() - 2) : key;
                    NewDrawSettingsCodeGen.this.computedPointClouds.put(key, new PointCloud(key, NewDrawSettingsCodeGen.this.colors.get(myKey), points));
                }
                NewDrawSettingsCodeGen.this.findingComplete(sum, (double)(System.currentTimeMillis() - start) / 1000.0);
            }
        }.start();
    }

    private String getDisplayEquationsAsString() {
        LinkedList<AssignmentNode> list = new LinkedList<AssignmentNode>();
        for (AssignmentNode assignmentNode : this.graphAssignmentNodes) {
            list.add(assignmentNode.copyElements());
        }
        ReplaceVisitor visitor = new ReplaceVisitor(){

            private void visitVar(Variable node) {
                if (node.getName().equals("_V_X")) {
                    this.result = new Variable("x");
                }
                if (node.getName().equals("_V_Y")) {
                    this.result = new Variable("y");
                }
                if (node.getName().equals("_V_Z")) {
                    this.result = new Variable("z");
                }
            }

            public void visit(MultivectorComponent node) {
                this.visitVar((Variable)node);
            }

            public void visit(Variable node) {
                this.visitVar(node);
            }
        };
        for (AssignmentNode node : list) {
            node.setVariable((Variable)visitor.replace((Expression)node.getVariable()));
            node.setValue(visitor.replace(node.getValue()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("//All components that should be zero on the surface of the multivector");
        stringBuilder.append("\n");
        for (AssignmentNode node : list) {
            String name = node.getVariable().getName();
            String newName = this.renderingExpressions.get(name).toString();
            AssignmentNode nodeCpy = node.copyElements();
            nodeCpy.setVariable((Variable)new MultivectorComponent(newName, ((MultivectorComponent)nodeCpy.getVariable()).getBladeIndex()));
            stringBuilder.append(nodeCpy.toString());
            stringBuilder.append("\n");
        }
        list = this.createSumOfSquares(list);
        stringBuilder.append("\n");
        stringBuilder.append("//Sum of the squared components that should be zero on the surface of the multivector");
        stringBuilder.append("\n");
        for (AssignmentNode node : list) {
            stringBuilder.append(node.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private LinkedList<AssignmentNode> createSumOfSquares(LinkedList<AssignmentNode> nodes) {
        HashMap collect = new HashMap();
        for (AssignmentNode node : nodes) {
            MultivectorComponent m = (MultivectorComponent)node.getVariable();
            String name = m.getName();
            if (!collect.containsKey(name)) {
                collect.put(name, new LinkedList());
            }
            ((LinkedList)collect.get(name)).add(node);
        }
        LinkedList<AssignmentNode> myNodes = new LinkedList<AssignmentNode>();
        for (String s : collect.keySet()) {
            if (!s.startsWith("_V_PRODUCT")) continue;
            Expression sumOfSquares = null;
            if (((LinkedList)collect.get(s)).size() > 1) {
                for (AssignmentNode node : (LinkedList)collect.get(s)) {
                    Exponentiation square = new Exponentiation(node.getValue(), (Expression)new FloatConstant(2.0));
                    if (sumOfSquares == null) {
                        sumOfSquares = square;
                        continue;
                    }
                    sumOfSquares = new Addition(sumOfSquares, (Expression)square);
                }
            } else if (((LinkedList)collect.get(s)).size() == 1) {
                sumOfSquares = ((AssignmentNode)((LinkedList)collect.get(s)).getFirst()).getValue();
            }
            if (sumOfSquares == null) continue;
            AssignmentNode newNode = new AssignmentNode(null, new Variable(this.renderingExpressions.get(s).toString()), sumOfSquares);
            myNodes.add(newNode);
            NewDrawSettingsCodeGen.listInsertBefore(myNodes, newNode, (AssignmentNode)((LinkedList)collect.get(s)).getFirst());
            for (AssignmentNode node : (LinkedList)collect.get(s)) {
                myNodes.remove(node);
            }
        }
        return myNodes;
    }

    protected static void listInsertBefore(LinkedList<AssignmentNode> list, AssignmentNode toInsert, AssignmentNode before) {
        LinkedList<AssignmentNode> listCopy = new LinkedList<AssignmentNode>(list);
        list.clear();
        for (AssignmentNode node : listCopy) {
            if (node == before) {
                list.add(toInsert);
            }
            list.add(node);
        }
    }

    private void findingComplete(long sum, double tokenTime) {
        this.newDataSetAvailable = true;
        this.jLabel_Info.setText(sum + " points, time = " + tokenTime + " s");
        this.visiblePanel.setObjects(this.getDataSet().keySet(), this.renderingExpressions);
        this.renderingEngine.pointSize = this.settingsPanel.getPointSize();
    }

    private void repaintCommand() {
        this.newDataSetAvailable = true;
    }

    @Override
    public boolean isNewDataSetAvailable() {
        return this.newDataSetAvailable;
    }

    @Override
    public HashMap<String, PointCloud> getDataSet() {
        PointClouds pointClouds = new PointClouds();
        pointClouds.putAll(this.computedPointClouds);
        return pointClouds;
    }

    @Override
    public PointClouds getLoadedPointClouds() {
        return this.loadedPointClouds;
    }

    @Override
    public HashSet<String> getVisibleObjects() {
        return this.visiblePanel.getVisibleObjects();
    }

    public boolean isPositionVariable(String name) {
        if (name.equals("_V_X")) {
            return true;
        }
        if (name.equals("_V_Y")) {
            return true;
        }
        return name.equals("_V_Z");
    }
}

