/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.engines.lwjgl;

import de.gaalop.visualizer.PointCloud;
import de.gaalop.visualizer.PointClouds;
import de.gaalop.visualizer.Rendering;
import de.gaalop.visualizer.engines.lwjgl.RenderingEngine;
import de.gaalop.visualizer.engines.lwjgl.Vec3f;
import de.gaalop.visualizer.engines.lwjgl.recording.GIFRecorder;
import de.gaalop.visualizer.engines.lwjgl.recording.Recorder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public abstract class LwJglRenderingEngine
extends RenderingEngine {
    private double near = 0.1;
    private double far = 30.0;
    private Vec3f camPos = new Vec3f(0.0f, 2.0f, -10.0f);
    private Vec3f camDir = new Vec3f(0.0f, 0.0f, 1.0f);
    private Vec3f camUp = new Vec3f(0.0f, 1.0f, 0.0f);
    private float camAngleX = 0.0f;
    private float camAngleY = 0.0f;
    private int mouseX;
    private int mouseY;
    private int mouseButton;
    private float mouseSensitivy = 1.0f;
    private boolean[] buttonDown = new boolean[]{false, false, false};
    private static final int STATE_DOWN = 1;
    private static final int STATE_UP = 2;
    protected Rendering rendering;
    public Recorder recorder;
    private boolean changed = false;
    private boolean firstFrame = true;
    private int list = -1;

    public LwJglRenderingEngine(String lwJglNativePath, Rendering rendering) {
        this.rendering = rendering;
        Path lwjglLibraryPath = Paths.get(lwJglNativePath, new String[0]);
        System.setProperty("org.lwjgl.librarypath", lwjglLibraryPath.toAbsolutePath().toString());
    }

    public void startEngine() {
        int width = 800;
        int height = 600;
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(width, height));
            Display.setFullscreen((boolean)false);
            Display.setTitle((String)"Gaalop Visualization Window");
            Display.create();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GL11.glEnable((int)2929);
        GL11.glShadeModel((int)7425);
        this.changeSize(width, height);
        GL11.glDisable((int)2896);
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)65.0f, (float)((float)width / (float)height), (float)0.1f, (float)100.0f);
        GL11.glMatrixMode((int)5888);
    }

    @Override
    public void run() {
        this.startEngine();
        while (!Display.isCloseRequested()) {
            if (this.rendering.isNewDataSetAvailable()) {
                if (this.list != -1) {
                    GL11.glDeleteLists((int)this.list, (int)1);
                }
                this.list = GL11.glGenLists((int)1);
                GL11.glNewList((int)this.list, (int)4864);
                this.draw(this.rendering.getDataSet(), this.rendering.getVisibleObjects(), this.rendering.getLoadedPointClouds());
                GL11.glEndList();
                this.changed = true;
            }
            GL11.glClear((int)16640);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0f);
            GLU.gluLookAt((float)this.camPos.x, (float)this.camPos.y, (float)this.camPos.z, (float)(this.camPos.x + this.camDir.x), (float)(this.camPos.y + this.camDir.y), (float)(this.camPos.z + this.camDir.z), (float)this.camUp.x, (float)this.camUp.y, (float)this.camUp.z);
            GL11.glRotatef((float)this.camAngleX, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.camAngleY, (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.list != -1) {
                GL11.glCallList((int)this.list);
            }
            this.pollInput();
            Display.update();
            if (this.recorder != null) {
                if (this.changed || this.firstFrame) {
                    this.recorder.makeScreenshot();
                    this.changed = false;
                }
                this.firstFrame = false;
                Display.sync((int)25);
                continue;
            }
            Display.sync((int)60);
        }
        Display.destroy();
    }

    public void mouseMoved(int x, int y) {
        switch (this.mouseButton) {
            case 1: {
                this.camAngleX = this.fmod(this.camAngleX + (float)(x - this.mouseX) * this.mouseSensitivy, 360.0f);
                this.camAngleY -= (float)(y - this.mouseY) * this.mouseSensitivy;
                if (this.camAngleY > 85.0f) {
                    this.camAngleY = 85.0f;
                }
                if (this.camAngleY < -85.0f) {
                    this.camAngleY = -85.0f;
                }
                this.changed = true;
                break;
            }
            case 2: {
                this.camPos.z -= 0.1f * (float)(y - this.mouseY) * this.mouseSensitivy;
                this.changed = true;
                break;
            }
            case 3: {
                this.camPos.x += 0.1f * (float)(x - this.mouseX) * this.mouseSensitivy;
                this.camPos.y -= 0.1f * (float)(y - this.mouseY) * this.mouseSensitivy;
                this.changed = true;
                break;
            }
        }
        this.mouseX = x;
        this.mouseY = y;
    }

    void mouseAction(int button, int state, int x, int y) {
        switch (button) {
            case 0: {
                if (state == 1) {
                    this.mouseButton = 1;
                    this.mouseX = x;
                    this.mouseY = y;
                    break;
                }
                this.mouseButton = 0;
                break;
            }
            case 1: {
                if (state == 1) {
                    this.mouseButton = 3;
                    this.mouseX = x;
                    this.mouseY = y;
                    break;
                }
                this.mouseButton = 0;
                break;
            }
            case 2: {
                if (state == 1) {
                    this.mouseButton = 2;
                    this.mouseX = x;
                    this.mouseY = y;
                    break;
                }
                this.mouseButton = 0;
            }
        }
    }

    private void pollInput() {
        if (Keyboard.isKeyDown((int)61) && this.recorder == null) {
            this.recorder = new GIFRecorder();
            this.recorder.startRecording();
        }
        if (Keyboard.isKeyDown((int)62) && this.recorder != null) {
            this.recorder.stopRecording();
            this.recorder = null;
        }
        if (Keyboard.isKeyDown((int)1)) {
            if (this.recorder != null) {
                this.recorder.stopRecording();
            }
            Display.destroy();
            System.exit(0);
        }
        int x = Mouse.getX();
        int y = Mouse.getY();
        for (int button = 0; button <= 2; ++button) {
            if (Mouse.isButtonDown((int)button)) {
                if (!this.buttonDown[button]) {
                    this.mouseAction(button, 1, x, y);
                } else {
                    this.mouseMoved(x, y);
                }
                this.buttonDown[button] = true;
                continue;
            }
            if (this.buttonDown[button]) {
                this.mouseAction(button, 2, x, y);
            }
            this.buttonDown[button] = false;
        }
    }

    private void changeSize(float w, float h) {
        if (h == 0.0f) {
            h = 1.0f;
        }
        float wRatio = 1.0f * w / h;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)((int)w), (int)((int)h));
        GLU.gluPerspective((float)45.0f, (float)wRatio, (float)((float)this.near), (float)((float)this.far));
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GLU.gluLookAt((float)this.camPos.x, (float)this.camPos.y, (float)this.camPos.z, (float)(this.camPos.x + this.camDir.x), (float)(this.camPos.y + this.camDir.y), (float)(this.camPos.z + this.camDir.z), (float)this.camUp.x, (float)this.camUp.y, (float)this.camUp.z);
    }

    private float fmod(float value, float modulo) {
        while (value < 0.0f) {
            value += modulo;
        }
        while (value > modulo) {
            value -= modulo;
        }
        return value;
    }

    public abstract void draw(HashMap<String, PointCloud> var1, HashSet<String> var2, PointClouds var3);
}

