/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.engines.lwjgl;

import de.gaalop.visualizer.Point3d;
import de.gaalop.visualizer.PointCloud;
import de.gaalop.visualizer.PointClouds;
import de.gaalop.visualizer.Rendering;
import de.gaalop.visualizer.engines.lwjgl.LwJglRenderingEngine;
import java.util.HashMap;
import java.util.HashSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

public class SimpleLwJglRenderingEngine
extends LwJglRenderingEngine {
    public SimpleLwJglRenderingEngine(String lwJglNativePath, Rendering rendering) {
        super(lwJglNativePath, rendering);
    }

    @Override
    public void draw(HashMap<String, PointCloud> clouds, HashSet<String> visibleObjects, PointClouds loadedClouds) {
        if (clouds == null) {
            return;
        }
        GL11.glBegin((int)1);
        GL11.glColor4d((double)1.0, (double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glColor4d((double)0.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glColor4d((double)0.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glEnd();
        for (String string : clouds.keySet()) {
            if (!visibleObjects.contains(string)) continue;
            this.paintPointCloud(clouds.get(string));
        }
        for (PointCloud pointCloud : loadedClouds.values()) {
            this.paintPointCloud(pointCloud);
        }
    }

    private void paintPointCloud(PointCloud pointCloud) {
        Sphere s = new Sphere();
        GL11.glColor4d((double)((double)pointCloud.color.getRed() / 255.0), (double)((double)pointCloud.color.getGreen() / 255.0), (double)((double)pointCloud.color.getBlue() / 255.0), (double)((double)pointCloud.color.getAlpha() / 255.0));
        for (Point3d p : pointCloud.points) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)p.x, (double)p.y, (double)p.z);
            s.draw(0.04f, 3, 3);
            GL11.glPopMatrix();
        }
    }
}

