/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.engines.lwjgl.recording;

import de.gaalop.visualizer.engines.lwjgl.recording.RecByteBufferAndTime;
import de.gaalop.visualizer.engines.lwjgl.recording.Recorder;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.lwjgl.opengl.Display;

public class TransformationThread
extends Thread {
    private final LinkedList<RecByteBufferAndTime> list = new LinkedList();
    private boolean terminate = false;
    private Recorder recorder;

    public TransformationThread(Recorder recorder) {
        this.recorder = recorder;
    }

    public void terminate() {
        this.terminate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(ByteBuffer buffer, long delay) {
        RecByteBufferAndTime b = new RecByteBufferAndTime(buffer, delay);
        LinkedList<RecByteBufferAndTime> linkedList = this.list;
        synchronized (linkedList) {
            this.list.add(b);
        }
    }

    @Override
    public void run() {
        while (!this.terminate) {
            if (!this.list.isEmpty()) {
                RecByteBufferAndTime b = this.list.removeFirst();
                BufferedImage image = this.transformPixelsRGBBuffer2ARGB_ByHand(b.getByteBuffer());
                this.recorder._addFrame(image, b.getDelay());
            }
            Thread.yield();
        }
        this.recorder._finish();
    }

    private BufferedImage transformPixelsRGBBuffer2ARGB_ByHand(ByteBuffer pixelsRGB) {
        int width = Display.getDisplayMode().getWidth();
        int height = Display.getDisplayMode().getHeight();
        int[] pixelInts = new int[width * height];
        int p = width * height * 3;
        int i = 0;
        int w3 = width * 3;
        for (int row = 0; row < height; ++row) {
            int q = p -= w3;
            for (int col = 0; col < width; ++col) {
                byte iR = pixelsRGB.get(q++);
                byte iG = pixelsRGB.get(q++);
                byte iB = pixelsRGB.get(q++);
                pixelInts[i++] = 0xFF000000 | (iR & 0xFF) << 16 | (iG & 0xFF) << 8 | iB & 0xFF;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        bufferedImage.setRGB(0, 0, width, height, pixelInts, 0, width);
        return bufferedImage;
    }
}

