/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.gui;

import de.gaalop.visualizer.gui.LabeledComponent;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SettingsPanel {
    private JCheckBox autoRendering = new JCheckBox("Automatic Rendering", false);
    private JTextField jTF_pointSize = new JTextField("0.2");
    private LabeledComponent lcPointSize = new LabeledComponent("point size", this.jTF_pointSize);
    private LinkedList<LabeledComponent> settings = new LinkedList();
    private JScrollPane scrollPane;
    private JPanel panelSettings;

    public SettingsPanel(JScrollPane scrollPane, JPanel panelSettings) {
        this.scrollPane = scrollPane;
        this.panelSettings = panelSettings;
    }

    public boolean isAutoRendering() {
        return this.autoRendering.isSelected();
    }

    public float getPointSize() {
        return Float.parseFloat(this.jTF_pointSize.getText());
    }

    public HashMap<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (LabeledComponent c : this.settings) {
            result.put(c.text, ((JTextField)c.component).getText());
        }
        return result;
    }

    public void setSettings(HashMap<String, String> settings) {
        this.settings.clear();
        this.panelSettings.removeAll();
        int rows = settings.size() + 2;
        this.panelSettings.setLayout(new GridLayout(Math.max(9, rows), 1, 5, 5));
        this.panelSettings.add(this.autoRendering);
        this.panelSettings.add(this.lcPointSize);
        for (String key : settings.keySet()) {
            LabeledComponent lc = new LabeledComponent(key, new JTextField(settings.get(key)));
            this.panelSettings.add(lc);
            this.settings.add(lc);
        }
        this.scrollPane.setViewportView(this.panelSettings);
    }
}

