/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.zerofinding;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.visitors.ReplaceVisitor;
import de.gaalop.visualizer.Point3d;
import de.gaalop.visualizer.zerofinding.CodePiece;
import de.gaalop.visualizer.zerofinding.DiscreteCubeMethod;
import de.gaalop.visualizer.zerofinding.GradientMethodThread;
import de.gaalop.visualizer.zerofinding.InsertingExpression;
import de.gaalop.visualizer.zerofinding.PrepareZerofinder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GradientMethod
extends PrepareZerofinder {
    public static void replace(LinkedList<AssignmentNode> nodes) {
        ReplaceVisitor visitor = new ReplaceVisitor(){

            private void visitVar(Variable node) {
                if (node.getName().equals("_V_X")) {
                    this.result = new MultivectorComponent("_V_ox", 0);
                }
                if (node.getName().equals("_V_Y")) {
                    this.result = new MultivectorComponent("_V_oy", 0);
                }
                if (node.getName().equals("_V_Z")) {
                    this.result = new MultivectorComponent("_V_oz", 0);
                }
            }

            public void visit(MultivectorComponent node) {
                this.visitVar((Variable)node);
            }

            public void visit(Variable node) {
                this.visitVar(node);
            }
        };
        for (AssignmentNode node : nodes) {
            node.setVariable((Variable)visitor.replace((Expression)node.getVariable()));
            node.setValue(visitor.replace(node.getValue()));
        }
    }

    private void diffentiateCodePieces(LinkedList<CodePiece> codePieces) {
        for (CodePiece cp : codePieces) {
            LinkedList<AssignmentNode> derived = this.differentiater.differentiate(cp, new MultivectorComponent("_V_ox", 0));
            if (derived != null) {
                for (AssignmentNode d : derived) {
                    d.setVariable((Variable)new MultivectorComponent(d.getVariable().getName() + "Dx", 0));
                    cp.add(d);
                }
            }
            if ((derived = this.differentiater.differentiate(cp, new MultivectorComponent("_V_oy", 0))) != null) {
                for (AssignmentNode d : derived) {
                    d.setVariable((Variable)new MultivectorComponent(d.getVariable().getName() + "Dy", 0));
                    cp.add(d);
                }
            }
            if ((derived = this.differentiater.differentiate(cp, new MultivectorComponent("_V_oz", 0))) == null) continue;
            for (AssignmentNode d : derived) {
                d.setVariable((Variable)new MultivectorComponent(d.getVariable().getName() + "Dz", 0));
                cp.add(d);
            }
        }
    }

    private LinkedList<CodePiece> prepareGraph(LinkedList<AssignmentNode> nodes) {
        GradientMethod.replace(nodes);
        InsertingExpression.insertExpressions(nodes);
        LinkedList<AssignmentNode> myNodes = GradientMethod.createSumOfSquares(nodes);
        LinkedList<CodePiece> codePieces = GradientMethod.optimizeCodePieces(myNodes);
        this.diffentiateCodePieces(codePieces);
        return codePieces;
    }

    @Override
    public HashMap<String, LinkedList<Point3d>> findZeroLocations(HashMap<MultivectorComponent, Double> globalValues, LinkedList<AssignmentNode> assignmentNodes, HashMap<String, String> mapSettings, boolean renderIn2d) {
        int a = Integer.parseInt(mapSettings.get("cubeEdgeLength"));
        float dist = Float.parseFloat(mapSettings.get("density"));
        double epsilon = Double.parseDouble(mapSettings.get("epsilon"));
        int max_n = Integer.parseInt(mapSettings.get("max_n"));
        LinkedList<CodePiece> codePieces = this.prepareGraph(assignmentNodes);
        HashMap<String, LinkedList<Point3d>> result = new HashMap<String, LinkedList<Point3d>>();
        for (CodePiece cp : codePieces) {
            LinkedList<Point3d> points = this.searchZeroLocations(cp, globalValues, a, dist, epsilon, max_n, renderIn2d);
            result.put(cp.nameOfMultivector, points);
        }
        return result;
    }

    @Override
    public String getName() {
        return "Gradient Method";
    }

    private LinkedList<Point3d> searchZeroLocations(CodePiece cp, HashMap<MultivectorComponent, Double> globalValues, int a, float dist, double epsilon, int max_n, boolean renderIn2d) {
        int i;
        LinkedList<Point3d> points = new LinkedList<Point3d>();
        int processorCount = Runtime.getRuntime().availableProcessors();
        GradientMethodThread[] threads = new GradientMethodThread[processorCount];
        for (i = 0; i < processorCount; ++i) {
            float from = (float)(i * 2 * a) / (float)processorCount - (float)a;
            float to = (i != processorCount - 1 ? (float)((i + 1) * 2 * a) / (float)processorCount : (float)(2 * a)) - (float)a;
            threads[i] = new GradientMethodThread(from, to, a, dist, globalValues, cp, epsilon, max_n, renderIn2d);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                points.addAll(threads[i].points);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DiscreteCubeMethod.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return points;
    }

    @Override
    public HashMap<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("cubeEdgeLength", "5");
        result.put("density", "1");
        result.put("epsilon", "1E-4");
        result.put("max_n", "50");
        return result;
    }
}

