/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.zerofinding;

import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.visualizer.Point3d;
import de.gaalop.visualizer.zerofinding.CodePiece;
import de.gaalop.visualizer.zerofinding.Evaluater;
import de.gaalop.visualizer.zerofinding.EvaluationResult;
import de.gaalop.visualizer.zerofinding.VecN3;
import java.util.HashMap;
import java.util.LinkedList;

public class GradientMethodThread
extends Thread {
    private float fromOX_Incl;
    private float toOX_Excl;
    private float a;
    private float dist;
    private HashMap<MultivectorComponent, Double> globalValues;
    private CodePiece codePiece;
    public LinkedList<Point3d> points = new LinkedList();
    private int max_n;
    private double epsilon;
    private boolean renderIn2d;

    public GradientMethodThread(float fromOX_Incl, float toOX_Excl, float a, float dist, HashMap<MultivectorComponent, Double> globalValues, CodePiece codePiece, double epsilon, int max_n, boolean renderIn2d) {
        this.fromOX_Incl = fromOX_Incl;
        this.toOX_Excl = toOX_Excl;
        this.a = a;
        this.dist = dist;
        this.globalValues = globalValues;
        this.codePiece = codePiece;
        this.epsilon = epsilon;
        this.max_n = max_n;
        this.renderIn2d = renderIn2d;
    }

    @Override
    public void run() {
        if (this.renderIn2d) {
            this.run2d();
        } else {
            this.run3d();
        }
    }

    private void run2d() {
        for (float ox = this.fromOX_Incl; ox <= this.toOX_Excl; ox += this.dist) {
            for (float oy = -this.a; oy <= this.a; oy += this.dist) {
                float[] resultSearch = this.searchInNeighborhood(ox, oy, 0.0f);
                if (resultSearch == null) continue;
                this.points.add(new Point3d(resultSearch[0], resultSearch[1], resultSearch[2]));
            }
        }
    }

    private void run3d() {
        for (float ox = this.fromOX_Incl; ox <= this.toOX_Excl; ox += this.dist) {
            for (float oy = -this.a; oy <= this.a; oy += this.dist) {
                for (float oz = -this.a; oz <= this.a; oz += this.dist) {
                    float[] resultSearch = this.searchInNeighborhood(ox, oy, oz);
                    if (resultSearch == null) continue;
                    this.points.add(new Point3d(resultSearch[0], resultSearch[1], resultSearch[2]));
                }
            }
        }
    }

    private float[] searchInNeighborhood(float ox, float oy, float oz) {
        double distDir = 1.0;
        EvaluationResult eval = this.evaluate(ox, oy, oz);
        double glastx = eval.gradient.x;
        double glasty = eval.gradient.y;
        double glastz = eval.gradient.z;
        for (int n = 1; Math.abs(eval.f) > this.epsilon && n <= this.max_n; ++n) {
            eval.gradient.normalize();
            if (glastx * eval.gradient.x + glasty * eval.gradient.y + glastz * eval.gradient.z < 0.0) {
                distDir /= 2.0;
            }
            ox = (float)((double)ox - eval.gradient.x * distDir);
            oy = (float)((double)oy - eval.gradient.y * distDir);
            oz = (float)((double)oz - eval.gradient.z * distDir);
            glastx = eval.gradient.x;
            glasty = eval.gradient.y;
            glastz = eval.gradient.z;
            eval = this.evaluate(ox, oy, oz);
        }
        if (Math.abs(eval.f) <= this.epsilon) {
            return new float[]{ox, oy, oz};
        }
        return null;
    }

    private EvaluationResult evaluate(float ox, float oy, float oz) {
        String productName = this.codePiece.nameOfMultivector;
        HashMap<MultivectorComponent, Double> valuesIn = new HashMap<MultivectorComponent, Double>(this.globalValues);
        valuesIn.put(new MultivectorComponent("_V_ox", 0), Double.valueOf(ox));
        valuesIn.put(new MultivectorComponent("_V_oy", 0), Double.valueOf(oy));
        valuesIn.put(new MultivectorComponent("_V_oz", 0), Double.valueOf(oz));
        Evaluater evaluater = new Evaluater(valuesIn);
        evaluater.evaluate(this.codePiece);
        HashMap<MultivectorComponent, Double> valuesOut = evaluater.getValues();
        EvaluationResult result = new EvaluationResult();
        result.f = valuesOut.get(new MultivectorComponent(productName, 0));
        result.gradient = new VecN3(valuesOut.get(new MultivectorComponent(productName + "Dx", 0)), valuesOut.get(new MultivectorComponent(productName + "Dy", 0)), valuesOut.get(new MultivectorComponent(productName + "Dz", 0)));
        return result;
    }
}

