/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.matlab;

import de.gaalop.DefaultCodeGeneratorVisitor;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Variable;

public class MatlabVisitor
extends DefaultCodeGeneratorVisitor {
    protected String variableType = "float";
    protected String filename;

    public MatlabVisitor(boolean useDouble, String filename) {
        this.filename = filename;
        if (useDouble) {
            this.variableType = "double";
        }
    }

    public MatlabVisitor(String variableType) {
        this.variableType = variableType;
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        this.code.append("function [");
        this.code.append(this.graph.getOutputs().join());
        this.code.append("] = " + this.filename + "(");
        this.code.append(this.graph.getInputs().join());
        this.code.append(")\n");
        ++this.indentation;
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        this.appendIndentation();
        node.getVariable().accept((ExpressionVisitor)this);
        this.code.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        this.code.append(";");
        if (node.getVariable() instanceof MultivectorComponent) {
            this.code.append(" % ");
            this.code.append(this.graph.getBladeString((MultivectorComponent)node.getVariable()));
        }
        this.code.append('\n');
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.appendIndentation();
        node.getExpression().accept((ExpressionVisitor)this);
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        --this.indentation;
        this.code.append("end\n");
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        String funcName;
        switch (mathFunctionCall.getFunction()) {
            case ABS: {
                funcName = "abs";
                break;
            }
            case SQRT: {
                funcName = "sqrt";
                break;
            }
            default: {
                funcName = mathFunctionCall.getFunction().toString().toLowerCase();
            }
        }
        this.code.append(funcName);
        this.code.append('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.code.append(')');
    }

    public void visit(Variable variable) {
        this.code.append(variable.getName());
    }

    public void visit(MultivectorComponent component) {
        this.code.append(component.getName());
        this.code.append('(');
        this.code.append(component.getBladeIndex() + 1);
        this.code.append(')');
    }

    public void visit(Exponentiation exponentiation) {
        if (this.isSquare(exponentiation)) {
            Multiplication m = new Multiplication(exponentiation.getLeft(), exponentiation.getLeft());
            m.accept((ExpressionVisitor)this);
        } else {
            this.code.append("power(");
            exponentiation.getLeft().accept((ExpressionVisitor)this);
            this.code.append(',');
            exponentiation.getRight().accept((ExpressionVisitor)this);
            this.code.append(')');
        }
    }

    public void visit(FloatConstant floatConstant) {
        this.code.append(Double.toString(floatConstant.getValue()));
    }

    public void visit(Negation negation) {
        this.code.append('(');
        this.code.append('-');
        this.addChild((Expression)negation, negation.getOperand());
        this.code.append(')');
    }
}

