/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cpp;

import de.gaalop.DefaultCodeGeneratorVisitor;
import de.gaalop.Notifications;
import de.gaalop.StringList;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Variable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class CppVisitor
extends DefaultCodeGeneratorVisitor {
    protected boolean standalone = true;
    protected Set<String> assigned = new HashSet<String>();
    protected String variableType = "float";
    protected Set<String> libraries = new HashSet<String>();

    public CppVisitor(boolean standalone) {
        this.standalone = standalone;
    }

    public CppVisitor(boolean standalone, boolean useDouble) {
        this.standalone = standalone;
        if (useDouble) {
            this.variableType = "double";
        }
    }

    public CppVisitor(String variableType) {
        this.standalone = false;
        this.variableType = variableType;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        int bladeCount = this.graph.getAlgebraDefinitionFile().getBladeCount();
        StringList outputs = this.graph.getOutputs();
        if (this.standalone) {
            this.appendIndentation();
            this.code.append("void " + this.graph.getSource().getName().split("\\.")[0] + "(");
            StringList parameters = new StringList();
            for (String var : this.graph.getInputs()) {
                parameters.add((Object)(this.variableType + " " + var));
            }
            for (String var : outputs) {
                parameters.add((Object)(this.variableType + " " + var + "[" + bladeCount + "]"));
            }
            this.code.append(parameters.join());
            this.code.append(") {\n");
            ++this.indentation;
        }
        for (String var : this.graph.getLocals()) {
            if (outputs.contains((Object)var)) continue;
            this.appendIndentation();
            this.code.append(this.variableType).append(" ");
            this.code.append(var);
            this.code.append("[" + bladeCount + "] = { 0.0 };\n");
        }
        if (this.graph.getScalarVariables().size() > 0) {
            this.appendIndentation();
            this.code.append(this.variableType).append(" ");
            this.code.append(this.graph.getScalars().join());
            this.code.append(";\n");
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        String variable = node.getVariable().getName();
        if (this.assigned.contains(variable)) {
            String message = "Variable " + variable + " has been reset for reuse.";
            this.log.warn((Object)message);
            Notifications.addWarning((String)message);
            this.appendIndentation();
            this.code.append("memset(");
            this.code.append(variable);
            this.code.append(", 0, sizeof(");
            this.code.append(variable);
            this.code.append(")); // Reset variable for reuse.\n");
            this.assigned.remove(variable);
        }
        this.appendIndentation();
        node.getVariable().accept((ExpressionVisitor)this);
        this.code.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        this.code.append(";");
        if (node.getVariable() instanceof MultivectorComponent) {
            this.code.append(" // ");
            this.code.append(this.graph.getBladeString((MultivectorComponent)node.getVariable()));
        }
        this.code.append("\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.appendIndentation();
        node.getExpression().accept((ExpressionVisitor)this);
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        this.assigned.add(node.getValue().getName());
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        if (this.standalone) {
            --this.indentation;
            this.appendIndentation();
            this.code.append("}\n");
        }
        if (!this.libraries.isEmpty()) {
            LinkedList<String> libs = new LinkedList<String>(this.libraries);
            libs.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            for (String lib : libs) {
                this.code.insert(0, "#" + lib + "\n");
            }
        }
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        String funcName;
        this.libraries.add("include <math.h>");
        switch (mathFunctionCall.getFunction()) {
            case ABS: {
                funcName = "fabs";
                break;
            }
            case SQRT: {
                funcName = "sqrtf";
                break;
            }
            default: {
                funcName = mathFunctionCall.getFunction().toString().toLowerCase();
            }
        }
        this.code.append(funcName);
        this.code.append('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.code.append(')');
    }

    public void visit(Variable variable) {
        this.code.append(variable.getName());
    }

    public void visit(MultivectorComponent component) {
        this.code.append(component.getName());
        this.code.append('[');
        this.code.append(component.getBladeIndex());
        this.code.append(']');
    }

    public void visit(Exponentiation exponentiation) {
        if (this.isSquare(exponentiation)) {
            Multiplication m = new Multiplication(exponentiation.getLeft(), exponentiation.getLeft());
            m.accept((ExpressionVisitor)this);
        } else {
            this.libraries.add("include <math.h>");
            this.code.append("pow(");
            exponentiation.getLeft().accept((ExpressionVisitor)this);
            this.code.append(',');
            exponentiation.getRight().accept((ExpressionVisitor)this);
            this.code.append(')');
        }
    }

    public void visit(FloatConstant floatConstant) {
        this.code.append(Double.toString(floatConstant.getValue()));
    }

    public void visit(Negation negation) {
        this.code.append('(');
        this.code.append('-');
        this.addChild((Expression)negation, negation.getOperand());
        this.code.append(')');
    }
}

