/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cpp;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.ConfigurationProperty;
import de.gaalop.Notifications;
import de.gaalop.cpp.CppCodeGenerator;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.Observable;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Plugin
extends Observable
implements CodeGeneratorPlugin {
    private Log log = LogFactory.getLog(Plugin.class);
    private Image icon;
    @ConfigurationProperty(type=ConfigurationProperty.Type.BOOLEAN)
    public boolean standalone = true;
    @ConfigurationProperty(type=ConfigurationProperty.Type.BOOLEAN)
    public boolean useDouble = false;

    public Plugin() {
        URL url = this.getClass().getResource("icon.png");
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to read plugin icon " + url));
            }
        } else {
            this.log.warn((Object)"Unable to find plugin icon!");
        }
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setUseDouble(boolean useDouble) {
        this.useDouble = useDouble;
    }

    public boolean getUseDouble() {
        return this.useDouble;
    }

    public CodeGenerator createCodeGenerator() {
        return new CppCodeGenerator(this);
    }

    public String getName() {
        return "C/C++";
    }

    public String getDescription() {
        return "This plugin generates C/C++ code.";
    }

    public Image getIcon() {
        return this.icon;
    }

    void notifyError(Throwable error) {
        this.setChanged();
        this.notifyObservers(new Notifications.Error(error));
    }
}

