/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.csharp;

import de.gaalop.NonarrayCodeGeneratorVisitor;
import de.gaalop.Notifications;
import de.gaalop.StringList;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Variable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CsharpVisitor
extends NonarrayCodeGeneratorVisitor {
    private static String MethodModifiers = "public static void";
    private static String MethodName = "Execute";
    protected boolean standalone = true;
    protected Set<String> assigned = new HashSet<String>();
    protected String mathLibrary = "MathF";
    protected Boolean useDouble = true;

    public CsharpVisitor(boolean standalone) {
        this.standalone = standalone;
    }

    public CsharpVisitor(String variableType) {
        this.standalone = false;
        this.numberType = variableType;
    }

    public CsharpVisitor(boolean standalone, boolean useDouble, boolean useArrays) {
        this.standalone = standalone;
        this.useDouble = useDouble;
        this.useArrays = useArrays;
        if (useDouble) {
            this.numberType = "double";
            this.mathLibrary = "Math";
        }
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        int bladeCount = this.graph.getAlgebraDefinitionFile().getBladeCount();
        StringList outputs = this.graph.getOutputs();
        this.declaredVariableNames.clear();
        if (this.standalone) {
            String filename = this.graph.getSource().getName().split("\\.")[0];
            this.appendIndentation();
            this.addCode("public static class " + filename + "\n{\n");
            ++this.indentation;
            this.appendIndentation();
            this.addCode(MethodModifiers + " " + MethodName + "(");
            StringList parameters = new StringList();
            for (String inputVariable : this.graph.getInputs()) {
                parameters.add((Object)(this.numberType + " " + inputVariable));
            }
            if (this.useArrays.booleanValue()) {
                for (String outputVariable : outputs) {
                    parameters.add((Object)(this.numberType + "[] " + outputVariable));
                }
            }
            this.addCode(parameters.join(", "));
            this.addCode(")\n");
            this.appendIndentation();
            this.addCode("{\n");
            ++this.indentation;
        }
        if (this.useArrays.booleanValue()) {
            for (String localVariable : this.graph.getLocals()) {
                if (outputs.contains((Object)localVariable)) continue;
                this.appendIndentation();
                this.addCode(this.numberType).append("[] ").append(localVariable);
                this.addCode(" = new ").append(this.numberType).append("[").append(bladeCount).append("];\n");
            }
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        Variable variable = node.getVariable();
        String variableName = this.getNewName(variable);
        if (this.assigned.contains(variableName)) {
            String message = "Variable " + variableName + " has been reset for reuse.";
            this.log.warn((Object)message);
            Notifications.addWarning((String)message);
            this.appendIndentation();
            this.addCode("memset(");
            this.addCode(variableName);
            this.addCode(", 0, sizeof(");
            this.addCode(variableName);
            this.addCode(")); // Reset variable for reuse.\n");
            this.assigned.remove(variableName);
        }
        this.appendIndentation();
        if (this.useArrays.booleanValue()) {
            variable.accept((ExpressionVisitor)this);
        } else {
            if (this.declaredVariableNames.add(variableName)) {
                this.addCode(this.numberType + " ");
            }
            this.addCode(variableName);
        }
        this.addCode(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        if (this.useArrays.booleanValue() && variable instanceof MultivectorComponent) {
            MultivectorComponent component = (MultivectorComponent)variable;
            this.addCode("; // " + this.graph.getBladeString(component) + "\n");
        } else {
            this.addCode(";\n");
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.appendIndentation();
        node.getExpression().accept((ExpressionVisitor)this);
        this.addCode(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        this.assigned.add(node.getValue().getNewName(this.graph, this.useArrays));
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        super.visit(node);
        if (this.standalone) {
            --this.indentation;
            this.appendIndentation();
            this.addCode("}\n");
            --this.indentation;
            this.addCode("}\n");
        }
        if (!this.libraries.isEmpty()) {
            LinkedList<String> libs = new LinkedList<String>(this.libraries);
            libs.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            for (String library : this.libraries) {
                this.code.insert(0, library + "\n");
            }
        }
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        String funcName;
        switch (mathFunctionCall.getFunction()) {
            case ABS: {
                funcName = this.getMathLibrary() + ".Abs";
                break;
            }
            case SQRT: {
                funcName = this.getMathLibrary() + ".Sqrt";
                break;
            }
            case COS: {
                funcName = this.getMathLibrary() + ".Cos";
                break;
            }
            case SIN: {
                funcName = this.getMathLibrary() + ".Sin";
                break;
            }
            case EXP: {
                funcName = this.getMathLibrary() + ".Exp";
                break;
            }
            default: {
                funcName = mathFunctionCall.getFunction().toString().toLowerCase();
            }
        }
        this.addCode(funcName);
        this.addCode('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.addCode(')');
    }

    public void visit(Variable variable) {
        this.addCode(this.getNewName(variable));
    }

    public void visit(MultivectorComponent component) {
        if (component.toString().equals("s1[1]")) {
            this.addCode("");
        }
        String name = component.getNewName(this.graph, this.useArrays);
        this.addCode(name);
    }

    public void visit(Exponentiation exponentiation) {
        if (this.isSquare(exponentiation)) {
            Multiplication m = new Multiplication(exponentiation.getLeft(), exponentiation.getLeft());
            m.accept((ExpressionVisitor)this);
        } else {
            this.libraries.add("using System;");
            this.addCode(this.mathLibrary + ".Pow(");
            exponentiation.getLeft().accept((ExpressionVisitor)this);
            this.addCode(',');
            exponentiation.getRight().accept((ExpressionVisitor)this);
            this.addCode(')');
        }
    }

    public void visit(FloatConstant floatConstant) {
        double value = floatConstant.getValue();
        this.addCode(Double.toString(value));
        if (!this.useDouble.booleanValue()) {
            this.addCode("f");
        }
    }

    public void visit(Negation negation) {
        this.addCode('(');
        this.addCode('-');
        this.addChild((Expression)negation, negation.getOperand());
        this.addCode(')');
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    private String getMathLibrary() {
        this.libraries.add("using System;\n");
        return this.mathLibrary;
    }

    protected void addReturnType(List<String> returnTypes) {
        String openingBracket = returnTypes.size() > 1 ? "(" : "";
        String closingBracket = returnTypes.size() > 1 ? ")" : "";
        String typeString = String.join((CharSequence)", ", returnTypes);
        String newline2 = typeString.length() > 50 ? (this.standalone ? "\n\t\t" : "\n") : "";
        this.replaceInCode(" void ", " " + openingBracket + typeString + closingBracket + " " + newline2);
    }
}

