/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.Graph;
import datapath.graph.Optimization;
import datapath.graph.UseEdge;
import datapath.graph.operations.Nop;
import datapath.graph.operations.Operation;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class BalanceOutput
extends Optimization {
    public BalanceOutput(Graph graph) {
        super(graph);
    }

    @Override
    public void perform() {
        for (Operation op : this.graph.getOperations().toArray(new Operation[0])) {
            this.balanceUse(op);
        }
    }

    private void balanceUse(Operation op) {
        Set<Operation> use = op.getUse();
        if (use.size() <= 1) {
            return;
        }
        TreeSet<UseEdge> uses = new TreeSet<UseEdge>();
        for (Operation x : use) {
            boolean added = uses.add(new UseEdge(op, x));
            assert (added);
        }
        if (((UseEdge)uses.first()).distance() == ((UseEdge)uses.last()).distance()) {
            return;
        }
        Set<UseEdge> shortestDistance = this.edgesWithShortestDistance(uses);
        int dist = shortestDistance.iterator().next().distance();
        uses.removeAll(shortestDistance);
        Nop nop = new Nop();
        for (UseEdge e : uses) {
            e.getTarget().replace(e.getSource(), nop);
        }
        nop.setSchedule(op.getSchedule() + op.getDelay() + dist);
        nop.setData(op);
        nop.setExecutionOrdinal(op.getExecutionOrdinal());
        this.graph.addOperation(nop);
        this.balanceUse(nop);
    }

    private Set<UseEdge> edgesWithShortestDistance(SortedSet<UseEdge> uses) {
        HashSet<UseEdge> shortest = new HashSet<UseEdge>(uses);
        UseEdge firstLonger = null;
        for (UseEdge e : uses) {
            if (e.distance() <= uses.first().distance()) continue;
            firstLonger = e;
            break;
        }
        assert (firstLonger != null);
        shortest.removeAll(uses.tailSet(firstLonger));
        return shortest;
    }
}

