/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.DeadTreeEliminationVisitor;
import datapath.graph.Graph;
import datapath.graph.Optimization;
import datapath.graph.operations.LoopEnd;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DeadTreeElimination
extends Optimization {
    private HashSet<String> outputVariables;

    public DeadTreeElimination(Graph g, Set<String> outputVariables) {
        super(g);
        this.outputVariables = new HashSet<String>(outputVariables);
    }

    @Override
    public void perform() {
        if (this.outputVariables.size() == 0) {
            return;
        }
        DeadTreeEliminationVisitor dte = new DeadTreeEliminationVisitor();
        Operation.nextVisit();
        HashSet<Operation> realOutputs = new HashSet<Operation>();
        for (ParentOutput parentOutput : this.graph.getOutput()) {
            if (!this.outputVariables.contains(parentOutput.getName())) continue;
            realOutputs.add(parentOutput);
        }
        if (realOutputs.size() == 0) {
            System.out.println("None of the pragma output variables found");
            return;
        }
        for (Operation operation : this.graph.getOperations()) {
            if (!(operation instanceof LoopEnd)) continue;
            realOutputs.add(operation);
        }
        for (Operation operation : realOutputs) {
            operation.postOrderUpwardVisit(dte);
        }
        for (Iterator<Operation> iterator : this.graph.getOperations().toArray(new Operation[0])) {
            if (((Operation)((Object)iterator)).isVisited()) continue;
            this.graph.remove((Operation)((Object)iterator));
            for (Operation pred : ((Operation)((Object)iterator)).dependsOnOperations(true)) {
                pred.removeUse((Operation)((Object)iterator));
            }
        }
    }
}

