/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.Graph;
import datapath.graph.Optimization;
import datapath.graph.UseEdge;
import datapath.graph.operations.Operation;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class EqualizeBackedges
extends Optimization {
    public EqualizeBackedges(Graph graph) {
        super(graph);
    }

    @Override
    public void perform() {
        TreeSet<UseEdge> backedges = new TreeSet<UseEdge>(this.collectBackedges());
        if (backedges.size() < 2) {
            return;
        }
        assert (((UseEdge)backedges.first()).isBackedge());
        assert (((UseEdge)backedges.last()).isBackedge());
        if (((UseEdge)backedges.first()).distance() == ((UseEdge)backedges.last()).distance()) {
            return;
        }
        int longestDistance = ((UseEdge)backedges.last()).distance();
        System.out.println("must equalize backedges");
        System.out.println("longest distance: " + longestDistance);
        System.out.println("shortest distance: " + ((UseEdge)backedges.first()).distance());
        for (UseEdge backedge : backedges) {
            if (backedge.distance() >= longestDistance) continue;
            int diff = longestDistance - backedge.distance();
            int newSchedule = backedge.getSource().getSchedule() + diff;
            backedge.getSource().setSchedule(newSchedule);
        }
    }

    private Set<UseEdge> collectBackedges() {
        HashSet<UseEdge> backedges = new HashSet<UseEdge>();
        for (Operation source : this.graph.getOperations()) {
            for (Operation target : source.getUse()) {
                if (!Graph.isBackEdge(source, target)) continue;
                UseEdge backedge = new UseEdge(source, target);
                backedges.add(backedge);
            }
        }
        return backedges;
    }
}

