/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.display.Display;
import datapath.graph.display.DisplayEdge;
import datapath.graph.display.DisplayFactory;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentInput;
import datapath.graph.operations.ParentOutput;
import datapath.graph.operations.Predicate;
import datapath.graph.operations.UnaryOperation;
import java.util.HashSet;
import java.util.Set;

public class Graph {
    private Set<Operation> operations = new HashSet<Operation>();
    private Set<Graph> innerLoops = new HashSet<Graph>();
    private static int lastId;
    private int id = lastId++;
    private int level;

    public Graph() {
        this(-1);
    }

    public Graph(int level) {
        this.level = level;
    }

    public void addOperation(Operation op) {
        this.operations.add(op);
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public int getId() {
        return this.id;
    }

    public Set<ParentInput> getInput() {
        HashSet<ParentInput> input = new HashSet<ParentInput>();
        for (Operation op : this.operations) {
            if (!(op instanceof ParentInput)) continue;
            input.add((ParentInput)op);
        }
        return input;
    }

    public Set<ParentOutput> getOutput() {
        HashSet<ParentOutput> output = new HashSet<ParentOutput>();
        for (Operation op : this.operations) {
            if (!(op instanceof ParentOutput)) continue;
            output.add((ParentOutput)op);
        }
        return output;
    }

    public static boolean isBackEdge(Operation source, Operation target) {
        return source.getExecutionOrdinal() > target.getExecutionOrdinal();
    }

    public static int getDistance(Operation source, Operation target) {
        return Math.abs(target.getSchedule() - source.getSchedule() - source.getDelay());
    }

    public void displayAll(DisplayFactory factory, String stage) {
        for (Graph graph : this.innerLoops) {
            graph.displayAll(factory);
        }
        this.display(factory);
    }

    public void displayAll(DisplayFactory factory) {
        this.displayAll(factory, "");
    }

    public void display(DisplayFactory factory, String stage) {
        Display disp = factory.display("Datapath Graph " + this.toString());
        for (Operation op : this.operations) {
            disp.addNode(factory.displayNode(op));
        }
        for (Operation op : this.operations) {
            if (op.getUse().size() == 0) {
                System.out.println("warning: op has no use " + op);
            }
            for (Operation target : op.getUse()) {
                if (Graph.isBackEdge(op, target)) {
                    disp.addEdge(factory.displayEdge(op, target, DisplayEdge.Type.Solid, DisplayEdge.Color.RED));
                    continue;
                }
                disp.addEdge(factory.displayEdge(op, target, DisplayEdge.Type.Solid, DisplayEdge.Color.BLACK));
            }
            for (Predicate pred : op.getPredicates()) {
                disp.addEdge(factory.displayEdge(pred, op, DisplayEdge.Type.Dashed, pred.getEdgeColor()));
            }
        }
        disp.display(stage);
    }

    public void display(DisplayFactory factory, ParentOutput output) {
        boolean changed;
        Display disp = factory.display("Datapath Output " + output.getDisplayLabel());
        HashSet<Operation> ops = new HashSet<Operation>();
        String name = output.getName();
        ops.add(output);
        ops.addAll(output.dependsOnOperations(true));
        do {
            changed = false;
            for (Operation op : ops.toArray(new Operation[0])) {
                if (!op.getDebugMessage().equals("") && !op.getDebugMessage().equals(name)) continue;
                changed |= ops.addAll(op.dependsOnOperations(true));
            }
        } while (changed);
        for (Operation op : ops) {
            disp.addNode(factory.displayNode(op));
        }
        for (Operation op : ops) {
            for (Operation target : op.getUse()) {
                if (!ops.contains(target)) continue;
                if (Graph.isBackEdge(op, target)) {
                    disp.addEdge(factory.displayEdge(op, target, DisplayEdge.Type.Solid, DisplayEdge.Color.RED));
                    continue;
                }
                disp.addEdge(factory.displayEdge(op, target, DisplayEdge.Type.Solid, DisplayEdge.Color.BLACK));
            }
        }
        disp.display(output.getName());
    }

    public void display(DisplayFactory factory) {
        this.display(factory, "");
    }

    public void remove(Operation op) {
        assert (this.operations.contains(op));
        this.operations.remove(op);
    }

    public void addInnerLoop(Graph g) {
        this.innerLoops.add(g);
    }

    public Set<Graph> getInnerLoops() {
        return this.innerLoops;
    }

    public int numOfOperation(boolean includeInnerLoops, Class<? extends Operation> type) {
        int numOperation = 0;
        if (includeInnerLoops) {
            for (Graph innerLoop : this.innerLoops) {
                numOperation += innerLoop.numOfOperation(includeInnerLoops, type);
            }
        }
        for (Operation op : this.operations) {
            if (op.getClass() != type) continue;
            ++numOperation;
        }
        return numOperation;
    }

    public String toString() {
        return String.format("Graph%d level:%d", this.id, this.level);
    }

    public boolean isTopLevel() {
        return this.level == 0;
    }

    public int getLatestSchedule() {
        int lastOp = 0;
        for (Operation op : this.operations) {
            lastOp = Math.max(lastOp, op.getSchedule());
        }
        return lastOp;
    }

    public void insertNode(UnaryOperation toInsert, Operation pred, Operation succ) {
        toInsert.setData(pred);
        this.addOperation(toInsert);
        succ.replace(pred, toInsert);
    }
}

