/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.operations.Dummy;
import datapath.graph.operations.Operation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Mapping<E> {
    private HashMap<E, Operation> map = new HashMap();
    private HashMap<E, Dummy> dummys = new HashMap();
    private HashMap<Dummy, HashSet<E>> dummyKeys = new HashMap();

    public void addToMap(E key, Operation tree) {
        assert (key != null) : "no declaration";
        assert (tree != null) : "no operation";
        assert (!this.map.containsKey(key)) : "new value for declaration " + key + " -> " + this.map.get(key) + " new: " + tree;
        HashSet<E> removedDummyKeys = null;
        if (this.dummys.containsKey(key)) {
            Dummy dummy = this.dummys.get(key);
            dummy.replaceWith(tree);
            removedDummyKeys = this.removeDummy(key);
        }
        if (tree instanceof Dummy) {
            this.addDummy(key, (Dummy)tree);
        } else {
            if (removedDummyKeys != null) {
                for (Object k : removedDummyKeys) {
                    this.map.put(k, tree);
                }
            }
            this.map.put(key, tree);
        }
    }

    public Operation getFromMap(E decl) {
        Operation ret = this.map.get(decl);
        if (ret == null && (ret = (Operation)this.dummys.get(decl)) == null) {
            ret = new Dummy(null);
            ret.setDebugMessage(decl.toString());
            this.addDummy(decl, (Dummy)ret);
        }
        return ret;
    }

    public Set<E> keySet() {
        return this.map.keySet();
    }

    public Set<E> dummyKeySet() {
        return this.dummys.keySet();
    }

    public Collection<Dummy> getDummys() {
        return this.dummys.values();
    }

    private void addDummy(E key, Dummy dummy) {
        assert (!this.dummys.containsKey(key));
        this.dummys.put(key, dummy);
        HashSet<E> keys = this.dummyKeys.get(dummy);
        if (keys == null) {
            keys = new HashSet();
            this.dummyKeys.put(dummy, keys);
        }
        keys.add(key);
    }

    private HashSet<E> removeDummy(E key) {
        assert (this.dummys.containsKey(key));
        Dummy dummy = this.dummys.remove(key);
        HashSet<E> keys = this.dummyKeys.get(dummy);
        assert (keys != null);
        for (E k : keys) {
            this.dummys.remove(k);
        }
        return this.dummyKeys.remove(dummy);
    }
}

