/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.Graph;
import datapath.graph.Modlib;
import datapath.graph.MulPipeCreator;
import datapath.graph.OperationVisitor;
import datapath.graph.modlib.Module;
import datapath.graph.modlib.Wire;
import datapath.graph.modlib.WireAnd;
import datapath.graph.modlib.WireConcat;
import datapath.graph.modlib.WireIO;
import datapath.graph.modlib.WireNot;
import datapath.graph.modlib.WireOR;
import datapath.graph.modlib.parameter.ADDR_WIDTH;
import datapath.graph.modlib.parameter.DATA_WIDTH;
import datapath.graph.modlib.parameter.DEPTH;
import datapath.graph.modlib.parameter.NIN;
import datapath.graph.modlib.parameter.QDEPTH;
import datapath.graph.modlib.parameter.SIGN;
import datapath.graph.modlib.parameter.VALUE;
import datapath.graph.modlib.parameter.WA;
import datapath.graph.modlib.parameter.WB;
import datapath.graph.modlib.parameter.WR;
import datapath.graph.operations.Absolut;
import datapath.graph.operations.Add;
import datapath.graph.operations.ArcCos;
import datapath.graph.operations.BinaryOperation;
import datapath.graph.operations.BitwidthTransmogrify;
import datapath.graph.operations.ConstantMultiplication;
import datapath.graph.operations.ConstantOperation;
import datapath.graph.operations.ConstantShift;
import datapath.graph.operations.Cos;
import datapath.graph.operations.Divide;
import datapath.graph.operations.FromOuterLoop;
import datapath.graph.operations.HWInput;
import datapath.graph.operations.HWOutput;
import datapath.graph.operations.Less;
import datapath.graph.operations.Loop;
import datapath.graph.operations.LoopEnd;
import datapath.graph.operations.LoopInit;
import datapath.graph.operations.MemWrite;
import datapath.graph.operations.Multiplication;
import datapath.graph.operations.Mux;
import datapath.graph.operations.Negation;
import datapath.graph.operations.Nop;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentInput;
import datapath.graph.operations.ParentOutput;
import datapath.graph.operations.Predicate;
import datapath.graph.operations.Predication;
import datapath.graph.operations.ShiftMode;
import datapath.graph.operations.Sin;
import datapath.graph.operations.SquareRoot;
import datapath.graph.operations.Subtraction;
import datapath.graph.operations.ToInnerLoop;
import datapath.graph.operations.ToOuterLoop;
import datapath.graph.operations.TopLevelInput;
import datapath.graph.operations.TypeConversion;
import datapath.graph.operations.UnaryOperation;
import datapath.graph.operations.VariableShift;
import datapath.graph.type.FixedPoint;
import datapath.graph.type.Float;
import datapath.graph.type.Integer;
import datapath.graph.type.Type;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModlibWriter
implements OperationVisitor {
    public static boolean mul_pipe = true;
    public static boolean mul_pipe_create = true;
    private Graph graph;
    private BufferedWriter writer;
    private Wire CE = new Wire("CE");
    private Wire CLK = new Wire("CLK");
    private Wire RESET = new Wire("RESET");
    private Wire INIT = new Wire("INIT");
    private Wire END = new Wire("END");
    private HashSet<Module> modules;
    HashMap<Operation, Wire> wireSources = new HashMap();
    int combinedDepth;
    int highestDepth;
    HashSet<MulPipeCreator.Options> mulpipes;

    private ModlibWriter(Graph graph, BufferedWriter writer) {
        this.writer = writer;
        this.modules = new HashSet();
    }

    private WireIO getWireIO(Operation source, String port) {
        Wire w = this.getWire(source);
        return new WireIO(w, port);
    }

    private Wire getWire(Operation source) {
        Wire w = this.wireSources.get(source);
        if (w == null) {
            w = new Wire(ModlibWriter.getDataWire(source));
            w.setSize(source.getOutputBitsize());
            this.wireSources.put(source, w);
        }
        return w;
    }

    private DEPTH getDepth(Operation op) {
        int depth = -1;
        for (Operation use : op.getUse()) {
            if (depth == -1) {
                depth = Graph.getDistance(op, use);
            }
            assert (Graph.getDistance(op, use) == depth) : "different depths -> possible scheduling error " + op;
        }
        depth = Math.max(depth, 0);
        this.combinedDepth += depth;
        if (!(op instanceof LoopInit)) {
            this.highestDepth = Math.max(this.highestDepth, depth);
        }
        return new DEPTH(depth);
    }

    public static String getDataWire(Operation source) {
        return String.format("dw_op%d", source.getNumber());
    }

    private Wire getControlWireAnd(Set<Predicate> predicates) {
        ArrayList<Wire> wires = new ArrayList<Wire>();
        for (Predicate p : predicates) {
            wires.add(this.getControlWire(p));
        }
        return new WireAnd(wires.toArray(new Wire[0]));
    }

    private Wire getControlWireOR(Set<Predicate> predicates) {
        ArrayList<Wire> wires = new ArrayList<Wire>();
        for (Predicate p : predicates) {
            wires.add(this.getControlWire(p));
        }
        return new WireOR(wires.toArray(new Wire[0]));
    }

    private Wire getControlWire(Predicate pred) {
        assert (pred.getData().getOutputBitsize() == 1);
        switch (pred.getPredicationType()) {
            case INIT: 
            case TRUE: {
                return this.getWire(pred.getData());
            }
            case FALSE: {
                return new WireNot(this.getWire(pred.getData()));
            }
        }
        throw new RuntimeException("don't know the predicate type");
    }

    private Wire getPredicationWire(Predication pred) {
        ArrayList<Wire> w = new ArrayList<Wire>();
        for (Predicate p : pred.getPredicates()) {
            w.add(this.getControlWire(p));
        }
        return new WireAnd(w.toArray(new Wire[0]));
    }

    private static void writeRecursive(Graph graph, BufferedWriter writer) throws IOException {
        for (Graph g : graph.getInnerLoops()) {
            ModlibWriter.writeRecursive(g, writer);
        }
        ModlibWriter w = new ModlibWriter(graph, writer);
        w.write("`timescale 1ns / 1ns\n");
        w.write(graph);
    }

    private void write(Graph graph) throws IOException {
        this.combinedDepth = 0;
        this.highestDepth = 0;
        this.mulpipes = new HashSet();
        for (Operation op : graph.getOperations()) {
            if (!op.isHardwareOperation()) continue;
            op.visit(this);
        }
        this.write("// new loop\n");
        this.write(String.format("// latest schedule is %d\n", graph.getLatestSchedule()));
        this.write(String.format("// combined depth: %d\n", this.combinedDepth));
        this.write(String.format("// highest depth: %d\n", this.highestDepth));
        int numAdd = graph.numOfOperation(true, Add.class);
        int numSub = graph.numOfOperation(true, Subtraction.class);
        int numMul = graph.numOfOperation(true, Multiplication.class);
        int numDiv = graph.numOfOperation(true, Divide.class);
        int numCos = graph.numOfOperation(true, Cos.class);
        int numSin = graph.numOfOperation(true, Sin.class);
        int numSqrt = graph.numOfOperation(true, SquareRoot.class);
        int numTotal = numAdd + numSub + numMul + numDiv + numCos + numSin + numSqrt;
        this.write("// number of operations\n");
        this.write(String.format("// add: %d\n", numAdd));
        this.write(String.format("// sub: %d\n", numSub));
        this.write(String.format("// div: %d\n", numDiv));
        this.write(String.format("// mul: %d\n", numMul));
        this.write(String.format("// cos: %d\n", numCos));
        this.write(String.format("// sin: %d\n", numSin));
        this.write(String.format("// sqrt: %d\n", numSqrt));
        this.write(String.format("// total: %d\n", numTotal));
        this.write("module graph" + graph.getId() + "\n");
        this.write("(\n");
        this.write("input wire RESULT_ACCEPT,\n");
        this.write("input wire CANCEL,\n");
        this.write("input wire CANCEL_STATE_RESET,\n");
        this.write("input wire START,\n");
        this.write("input wire START_CTRL,\n");
        this.write("input wire " + this.CLK.withSize() + ",\n");
        this.write("input wire " + this.RESET.withSize() + ",\n");
        this.write("input wire " + this.INIT.withSize() + ",\n");
        this.write("output wire " + this.END.withSize() + ",\n");
        this.write("input wire " + this.CE.withSize());
        for (ParentInput pin : graph.getInput()) {
            this.write(",\n");
            this.write("input wire " + this.getWire(pin.getSource()).withSize());
            this.wireSources.remove(pin.getSource());
        }
        for (ParentOutput pout : graph.getOutput()) {
            this.write(",\n");
            this.write("output wire " + this.getWire(pout).withSize());
            this.wireSources.remove(pout);
        }
        this.write("\n);\n");
        for (Wire w : this.wireSources.values()) {
            this.writeWire(w);
            this.write("\n");
        }
        this.addCommonControl();
        for (Module m : this.modules) {
            this.write(Modlib.module(m));
            this.write("\n");
        }
        this.write("endmodule\n");
        if (mul_pipe_create && mul_pipe) {
            System.out.println("number of different mul_pipe:" + this.mulpipes.size());
            System.out.println(this.mulpipes);
            MulPipeCreator.c(this.mulpipes);
        }
    }

    public static void write(Graph g, BufferedWriter writer) {
        try {
            ModlibWriter.writeRecursive(g, writer);
            writer.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(ModlibWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void visit(Operation op) {
        System.err.println(op.getClass() + " not supported");
    }

    @Override
    public void visit(BinaryOperation op) {
    }

    @Override
    public void visit(Mux op) {
        Set<Operation> preds = op.getOperands();
        ArrayList<Wire> Aw = new ArrayList<Wire>();
        ArrayList<Wire> Bw = new ArrayList<Wire>();
        for (Predication predication : preds) {
            Aw.add(this.getWire(predication.getData()));
            Bw.add(this.getPredicationWire(predication));
        }
        Module m = new Module("mux", op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new WA(op.getOutputBitsize()));
        m.addParameter(new SIGN(op.isSigned()));
        m.addParameter(this.getDepth(op));
        m.addParameter(new NIN(Aw.size()));
        m.addIO(this.getWireIO(op, "R"));
        m.addIO(new WireIO(new WireConcat(Aw.toArray(new Wire[0])), "A"));
        m.addIO(new WireIO(new WireConcat(Bw.toArray(new Wire[0])), "B"));
        m.addIO(new WireIO(new WireOR(Bw.toArray(new Wire[0])), "START"));
        this.modules.add(m);
    }

    @Override
    public void visit(ConstantOperation op) {
        Module m = new Module("const_op", op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new VALUE(String.format("%d'h%s", op.getOutputBitsize(), op.toHex())));
        DEPTH depth = this.getDepth(op);
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(Add op) {
        Type type = op.getType();
        if (type instanceof Integer) {
            this.binaryOp("add", op);
        } else if (type instanceof FixedPoint) {
            this.binaryOp("add", op);
        } else if (type instanceof Float) {
            this.binaryOp("addfloat", op);
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private void writeWire(Wire w) {
        this.write("wire " + w.withSize() + ";");
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException ex) {
            Logger.getLogger(ModlibWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addCommonControl() {
        for (Module m : this.modules) {
            if (m.getType().equals("const_op")) {
                m.addParameter(new QDEPTH(1));
            } else {
                m.addParameter(new QDEPTH(0));
            }
            m.addIO(new WireIO(this.CLK, "CLK"));
            m.addIO(new WireIO(this.CE, "CE"));
            m.addIO(new WireIO(new Wire("1'b1"), "START"));
            m.addIO(new WireIO(new Wire("1'b1"), "RESULT_ACCEPT"));
            m.addIO(new WireIO(new Wire("1'b0"), "CANCEL"));
            m.addIO(new WireIO(new Wire("1'b1"), "START_CTRL"));
            m.addIO(new WireIO(new Wire("1'b1"), "CANCEL_STATE_RESET"));
            m.addIO(new WireIO(new Wire("1'b1"), "CANCEL_STATE_CTRL_RESET"));
            m.addIO(new WireIO(this.RESET, "RESET"));
        }
    }

    @Override
    public void visit(Less op) {
        this.binaryOp("cmplt", op);
    }

    private void binaryOp(String name, BinaryOperation op) {
        Module m = new Module(name, op.getNumber());
        m.addParameter(new WA(op.getLhs().getOutputBitsize()));
        m.addParameter(new WB(op.getRhs().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new SIGN(op.isSigned()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op.getLhs(), "A"));
        m.addIO(this.getWireIO(op.getRhs(), "B"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    private void unaryOp(String name, UnaryOperation op) {
        Module m = new Module(name, op.getNumber());
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new SIGN(op.isSigned()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(MemWrite op) {
        Module m = new Module("memwrite", op.getNumber());
        m.addParameter(new ADDR_WIDTH(op.getAddress().getOutputBitsize()));
        m.addParameter(new DATA_WIDTH(op.getData().getOutputBitsize()));
        m.addIO(this.getWireIO(op.getAddress(), "A"));
        m.addIO(this.getWireIO(op.getData(), "B"));
        Wire start = this.getControlWireAnd(op.getPredicates());
        m.addIO(new WireIO(start, "START"));
        this.modules.add(m);
    }

    @Override
    public void visit(FromOuterLoop op) {
        Module m = new Module("nop", "FromOuterLoop", op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new WA(op.getSource().getOutputBitsize()));
        m.addParameter(new DEPTH(0));
        m.addIO(this.getWireIO(op, "R"));
        m.addIO(this.getWireIO(op.getSource(), "A"));
        this.modules.add(m);
    }

    @Override
    public void visit(ToInnerLoop op) {
        Module m = new Module("nop", op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(Loop op) {
        Module m = new Module("graph" + op.getGraph().getId(), op.getGraph().getId());
        for (ParentInput pin : op.getGraph().getInput()) {
            m.addIO(this.getWireIO(pin.getSource(), ModlibWriter.getDataWire(pin.getSource())));
        }
        for (ParentOutput pout : op.getGraph().getOutput()) {
            m.addIO(this.getWireIO(pout, ModlibWriter.getDataWire(pout)));
        }
        this.modules.add(m);
    }

    @Override
    public void visit(HWInput op) {
        Module m = new Module("inreg", op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addIO(this.getWireIO(op, "R"));
    }

    @Override
    public void visit(VariableShift op) {
        String type;
        switch (op.getMode()) {
            case Left: {
                type = "vsl";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
        Module m = new Module(type, op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new WA(op.getLhs().getOutputBitsize()));
        m.addParameter(new WB(op.getRhs().getOutputBitsize()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op.getLhs(), "A"));
        m.addIO(this.getWireIO(op.getRhs(), "B"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(ConstantShift op) {
        Module m;
        ShiftMode mode = op.getMode();
        if (mode == ShiftMode.ZeroShiftLeft) {
            op.setShiftAmount(0);
            op.setMode(ShiftMode.Left);
        }
        if (mode == ShiftMode.ZeroShiftRight) {
            op.setShiftAmount(0);
            op.setMode(ShiftMode.Right);
        }
        mode = op.getMode();
        switch (mode) {
            case Right: {
                mode = op.isSigned() ? ShiftMode.SignedRight : ShiftMode.UnsignedRight;
            }
        }
        switch (mode) {
            case Left: {
                m = new Module("lsl", op.getNumber());
                m.addParameter(new WB(op.getShiftAmount()));
                break;
            }
            case SignedRight: {
                assert (op.getShiftAmount() >= 0);
                m = new Module("vsr", op.getNumber());
                m.addParameter(new WB(8));
                m.addParameter(new SIGN(true));
                m.addIO(new WireIO(new Wire("8'd" + op.getShiftAmount()), "B"));
                break;
            }
            case UnsignedRight: {
                m = new Module("lsr", op.getNumber());
                m.addParameter(new WB(op.getShiftAmount()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(Nop op) {
        Module m = new Module("nop", op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new DEPTH(Graph.getDistance(op, op.getUse().iterator().next())));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(ToOuterLoop op) {
        Module m = new Module("nop", "ToOuterLoop", op.getNumber());
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new DEPTH(1));
        m.addIO(this.getWireIO(op, "R"));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(new WireIO(this.getControlWireOR(op.getPredicates()), "START"));
        this.modules.add(m);
    }

    @Override
    public void visit(LoopEnd op) {
        Module m = new Module("nop", "LoopEnd", op.getNumber());
        m.addParameter(new WA(1));
        m.addParameter(new WR(1));
        m.addParameter(new DEPTH(1));
        m.addIO(new WireIO(this.getControlWireAnd(op.getPredicates()), "A"));
        m.addIO(new WireIO(this.END, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(LoopInit op) {
        Module m = new Module("nop", "LoopInit", op.getNumber());
        m.addParameter(new WA(1));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op, "R"));
        m.addIO(new WireIO(this.INIT, "A"));
        this.modules.add(m);
    }

    @Override
    public void visit(HWOutput op) {
        Module m = new Module("nop", "HWOutput", op.getNumber());
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new DEPTH(1));
        m.addIO(this.getWireIO(op, "R"));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(new WireIO(this.getControlWireOR(op.getPredicates()), "START"));
        this.modules.add(m);
    }

    @Override
    public void visit(TopLevelInput op) {
        Module m = new Module("nop", "TopLevelInput", op.getNumber());
        m.addParameter(new WA(op.getSource().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op, "R"));
        m.addIO(this.getWireIO(op.getSource(), "A"));
        this.modules.add(m);
    }

    @Override
    public void visit(Negation op) {
        Module m;
        Type type = op.getType();
        if (type instanceof Integer) {
            m = new Module("sub", op.getNumber());
        } else if (type instanceof FixedPoint) {
            m = new Module("sub", op.getNumber());
        } else if (type instanceof Float) {
            m = new Module("subfloat", op.getNumber());
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new WB(op.getData().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new SIGN(op.isSigned()));
        assert (op.getUse().size() > 0) : op + " has no use";
        m.addParameter(new DEPTH(Graph.getDistance(op, op.getUse().iterator().next())));
        m.addIO(this.getWireIO(op.getData(), "B"));
        m.addIO(new WireIO(new Wire(String.format("%d'd0", op.getData().getOutputBitsize())), "A"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(Multiplication op) {
        if (op.getLhs().getOutputBitsize() < op.getRhs().getOutputBitsize()) {
            Operation lhs = op.getLhs();
            Operation rhs = op.getRhs();
            op.removeLHS();
            op.removeRHS();
            op.setLHS(rhs);
            op.setRHS(lhs);
        }
        int lhs = op.getLhs().getOutputBitsize();
        int rhs = op.getRhs().getOutputBitsize();
        int bit = op.getOutputBitsize();
        Type type = op.getType();
        if (type instanceof Integer) {
            this.binaryOp("mul", op);
        } else if (type instanceof FixedPoint) {
            if (mul_pipe && lhs <= 64 && rhs <= 64 && bit <= 128) {
                if (mul_pipe_create) {
                    MulPipeCreator.Options ops = new MulPipeCreator.Options();
                    ops.WA = lhs;
                    ops.WB = rhs;
                    ops.WR = bit;
                    ops.signed = op.isSigned();
                    ops.stages = op.getDelay();
                    this.mulpipes.add(ops);
                }
                this.binaryOp("mul_pipe", op);
            } else {
                this.binaryOp("mul", op);
            }
        } else if (type instanceof Float) {
            this.binaryOp("mulfloat", op);
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @Override
    public void visit(Subtraction op) {
        Type type = op.getType();
        if (type instanceof Integer) {
            this.binaryOp("sub", op);
        } else if (type instanceof FixedPoint) {
            this.binaryOp("sub", op);
        } else if (type instanceof Float) {
            this.binaryOp("subfloat", op);
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @Override
    public void visit(Divide op) {
        Type type = op.getType();
        if (type instanceof Integer) {
            this.binaryOp("divint", op);
        } else if (type instanceof FixedPoint) {
            if (op.getOutputBitsize() == 64) {
                this.binaryOp("bigdiv", op);
            } else {
                this.binaryOp("divint", op);
            }
        } else if (type instanceof Float) {
            this.binaryOp("divfloat", op);
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @Override
    public void visit(Absolut op) {
        Type type = op.getType();
        Module m = null;
        if (type instanceof Integer) {
            m = new Module("abs", op.getNumber());
        } else if (type instanceof FixedPoint) {
            m = new Module("abs", op.getNumber());
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new SIGN(op.getData().isSigned()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(Sin op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Cos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ArcCos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(SquareRoot op) {
        Type type = op.getType();
        if (type instanceof Integer) {
            this.unaryOp("sqrtint", op);
        } else if (type instanceof FixedPoint) {
            this.unaryOp("sqrtint", op);
        } else {
            if (type instanceof Float) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @Override
    public void visit(BitwidthTransmogrify op) {
        Module m = new Module("bitsel", op.getNumber());
        m.addParameter(new WA(op.getData().getOutputBitsize()));
        m.addParameter(new WR(op.getOutputBitsize()));
        m.addParameter(new SIGN(op.isSigned()));
        m.addParameter(this.getDepth(op));
        m.addIO(this.getWireIO(op.getData(), "A"));
        m.addIO(this.getWireIO(op, "R"));
        this.modules.add(m);
    }

    @Override
    public void visit(Predicate op) {
    }

    @Override
    public void visit(TypeConversion op) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void visit(ConstantMultiplication op) {
        this.binaryOp("mul", op);
    }
}

