/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.Graph;
import datapath.graph.operations.Operation;
import java.util.ArrayList;
import java.util.HashSet;

public class StageControllerBuilder {
    private Graph graph;
    private ArrayList<Stage> stages;

    private StageControllerBuilder(Graph graph) {
        this.graph = graph;
    }

    public static void addStageController(Graph graph) {
        StageControllerBuilder builder = new StageControllerBuilder(graph);
        builder.build();
    }

    private void build() {
        this.collectStages();
    }

    private void collectStages() {
        int numStages = this.graph.getLatestSchedule() + 1;
        this.stages = new ArrayList(numStages);
        for (int i = 0; i < numStages; ++i) {
            this.stages.add(new Stage());
        }
        assert (this.stages.size() == numStages);
        for (Operation op : this.graph.getOperations()) {
            this.stages.get(op.getSchedule()).addOperation(op);
        }
        assert (this.stages.get(numStages - 1).numOperations() > 0);
    }

    private class Stage {
        HashSet<Operation> operations = new HashSet();

        Stage() {
        }

        void addOperation(Operation op) {
            this.operations.add(op);
        }

        int numOperations() {
            return this.operations.size();
        }
    }
}

