/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.Graph;
import datapath.graph.Modlib;
import datapath.graph.ModlibWriter;
import datapath.graph.SortByNumber;
import datapath.graph.modlib.Module;
import datapath.graph.modlib.Wire;
import datapath.graph.modlib.WireIO;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentInput;
import datapath.graph.operations.ParentOutput;
import datapath.graph.type.FixedPoint;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

public class TestbenchCreator {
    private Graph graph;
    private Writer writer;
    public static boolean fixpoint = true;

    private TestbenchCreator(Graph graph, Writer writer) {
        this.graph = graph;
        this.writer = writer;
    }

    public static void writeTestbench(Graph graph, Writer writer) throws IOException {
        TestbenchCreator creator = new TestbenchCreator(graph, writer);
        creator.create();
        writer.close();
    }

    private void create() {
        Wire io;
        HashMap<Wire, String> ios = new HashMap<Wire, String>();
        HashSet<Wire> in = new HashSet<Wire>();
        HashSet<Wire> regs = new HashSet<Wire>();
        HashSet<Wire> wires = new HashSet<Wire>();
        this.writeLine("`timescale 1ns / 1ns");
        this.writeLine("module testbench();");
        regs.add(new Wire("RESULT_ACCEPT"));
        regs.add(new Wire("CANCEL"));
        regs.add(new Wire("START"));
        regs.add(new Wire("START_CTRL"));
        regs.add(new Wire("CLK"));
        regs.add(new Wire("RESET"));
        regs.add(new Wire("INIT"));
        wires.add(new Wire("END"));
        regs.add(new Wire("CE"));
        TreeSet<Operation> input = new TreeSet<Operation>(new SortByNumber());
        input.addAll(this.graph.getInput());
        TreeSet<Operation> output = new TreeSet<Operation>(new SortByNumber());
        output.addAll(this.graph.getOutput());
        Module m = new Module("graph" + this.graph.getId(), "g", this.graph.getId());
        for (Wire wire : regs) {
            this.writeLine("reg " + wire.withSize() + ";");
            m.addIO(new WireIO(wire, wire.toString()));
        }
        for (Wire wire : wires) {
            this.writeLine("wire " + wire.withSize() + ";");
            m.addIO(new WireIO(wire, wire.toString()));
        }
        for (ParentInput parentInput : input) {
            io = new Wire(parentInput.getName());
            in.add(io);
            io.setSize(parentInput.getOutputBitsize());
            ios.put(io, ModlibWriter.getDataWire(parentInput.getSource()));
            this.writeLine("reg " + io.withSize() + ";");
        }
        for (ParentOutput parentOutput : output) {
            io = new Wire(parentOutput.getName());
            io.setSize(parentOutput.getOutputBitsize());
            ios.put(io, ModlibWriter.getDataWire(parentOutput));
            this.writeLine("wire " + io.withSize() + ";");
        }
        for (Map.Entry entry : ios.entrySet()) {
            m.addIO(new WireIO((Wire)entry.getKey(), (String)entry.getValue()));
        }
        this.writeLine(Modlib.module(m));
        this.writeLine("integer file;");
        this.writeLine("integer error;");
        this.writeLine("initial begin");
        for (Wire wire : regs) {
            this.writeLine(wire.toString() + " = 0;");
        }
        this.writeLine("file = $fopen(\"inputdata\", \"r\");");
        this.writeLine("$ferror(file, error);");
        this.writeLine("if (error != 0) begin");
        this.writeLine("// input data begins here");
        for (Wire wire : in) {
            this.writeLine(String.format("%s = %d'd0;", wire.toString(), wire.getSize()));
        }
        this.writeLine("// end of input data");
        this.writeLine("end");
        this.writeLine("else begin");
        this.writeLine("`include \"inputdata\"");
        this.writeLine("end");
        this.writeLine("#20 RESET=1;");
        this.writeLine("#10 RESET=0;");
        this.writeLine("#4");
        this.writeLine("INIT = 1;");
        this.writeLine("CE = 1;");
        this.writeLine("#5 INIT = 0;");
        if (fixpoint) {
            this.addFixpointOutput();
        }
        this.writeLine("end");
        this.writeLine("// clock with cycle length 10");
        this.writeLine("always begin");
        this.writeLine("#5 CLK=~CLK;");
        this.writeLine("end");
        this.writeLine("endmodule");
    }

    private void writeLine(String line) {
        try {
            this.writer.write(line);
            this.writer.write("\n");
        }
        catch (IOException ex) {
            System.err.println("Cannot write testbench");
        }
    }

    private void addFixpointOutput() {
        int bits;
        int frac;
        TreeSet<Operation> output = new TreeSet<Operation>(new SortByNumber());
        output.addAll(this.graph.getOutput());
        TreeSet<Operation> input = new TreeSet<Operation>(new SortByNumber());
        input.addAll(this.graph.getInput());
        this.writeLine("@(posedge END) begin");
        for (ParentInput parentInput : input) {
            assert (parentInput.getType() instanceof FixedPoint);
            frac = ((FixedPoint)parentInput.getType()).getFractionlength();
            bits = parentInput.getType().getBitsize();
            this.writeLine(TestbenchCreator.fixpoint(parentInput.getName(), frac, bits, parentInput.isSigned()));
        }
        for (ParentOutput parentOutput : output) {
            assert (parentOutput.getType() instanceof FixedPoint);
            frac = ((FixedPoint)parentOutput.getType()).getFractionlength();
            bits = parentOutput.getType().getBitsize();
            this.writeLine(TestbenchCreator.fixpoint(parentOutput.getName(), frac, bits, parentOutput.isSigned()));
        }
        this.writeLine("end");
    }

    private static String fixpoint(String name, int frac, int bits, boolean signed) {
        --bits;
        if (signed) {
            return String.format("$display(\"%s: %%s %%f\", (%s[%d:%d] == 1 )? \"-\": \" \", $itor((%s[%d:%d] == 1)? -%s:%s) / $itor(2)**%d);", name, name, bits, bits, name, bits, bits, name, name, frac);
        }
        return String.format("$display(\"%s: %%f\", %s / $itor(2)**%d);", name, name, frac);
    }
}

