/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.Graph;
import datapath.graph.Modlib;
import datapath.graph.modlib.Module;
import datapath.graph.modlib.Wire;
import datapath.graph.modlib.WireIO;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentInput;
import datapath.graph.operations.ParentOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TopLevelDummyCreator {
    private Writer writer;
    private Graph graph;

    private TopLevelDummyCreator(Graph g, Writer w) {
        this.writer = w;
        this.graph = g;
    }

    public static void create(Graph g, Writer w) {
        TopLevelDummyCreator c = new TopLevelDummyCreator(g, w);
        c.create();
    }

    private int maxInput() {
        int max = 0;
        for (ParentInput input : this.graph.getInput()) {
            max = Math.max(max, input.getOutputBitsize());
        }
        return max;
    }

    private int maxOutput() {
        int max = 0;
        for (ParentOutput output : this.graph.getOutput()) {
            max = Math.max(max, output.getOutputBitsize());
        }
        return max;
    }

    private void create() {
        Wire in = new Wire("in");
        Wire select = new Wire("select");
        Wire out = new Wire("out");
        Wire CLK = new Wire("CLK");
        Wire RESET = new Wire("RESET");
        Wire CE = new Wire("CE");
        Module m = new Module("graph" + this.graph.getId(), this.graph.getId());
        in.setSize(this.maxInput());
        out.setSize(this.maxOutput());
        select.setSize(10);
        this.writeLine("module topLevelDummy(");
        this.writeLine(String.format("input wire %s,", CLK.withSize()));
        this.writeLine(String.format("input wire %s,", CE.withSize()));
        this.writeLine(String.format("input wire %s,", RESET.withSize()));
        this.writeLine(String.format("output reg %s,", out.withSize()));
        this.writeLine(String.format("input wire %s, input wire %s);", in.withSize(), select.withSize()));
        HashSet<Operation> ops = new HashSet<Operation>();
        ops.addAll(this.graph.getInput());
        ops.addAll(this.graph.getOutput());
        for (ParentInput parentInput : this.graph.getInput()) {
            this.writeLine(String.format("reg [%d:0] reg%d;", parentInput.getOutputBitsize() - 1, parentInput.getNumber()));
        }
        for (ParentOutput parentOutput : this.graph.getOutput()) {
            this.writeLine(String.format("wire [%d:0] reg%d;", parentOutput.getOutputBitsize() - 1, parentOutput.getNumber()));
        }
        this.writeLine(String.format("always @(posedge %s) begin", CLK.toString()));
        this.writeLine(String.format("case(%s)", select));
        int i = 0;
        for (ParentInput input : this.graph.getInput()) {
            m.addIO(new WireIO(new Wire("reg" + input.getNumber()), "dw_op" + input.getSource().getNumber()));
            this.writeLine(String.format("%d: reg%d = in;", i, input.getNumber()));
            ++i;
        }
        this.writeLine("endcase");
        this.writeLine(String.format("case(%s)", select));
        i = 0;
        for (ParentOutput output : this.graph.getOutput()) {
            m.addIO(new WireIO(new Wire("reg" + output.getNumber()), "dw_op" + output.getNumber()));
            this.writeLine(String.format("%d: out = reg%d;", i, output.getNumber()));
            ++i;
        }
        this.writeLine("endcase");
        this.writeLine("end");
        m.addIO(new WireIO(CLK, "CLK"));
        m.addIO(new WireIO(new Wire("1'b1"), "INIT"));
        m.addIO(new WireIO(RESET, "RESET"));
        m.addIO(new WireIO(CE, "CE"));
        this.writeLine(Modlib.module(m));
        this.writeLine("endmodule");
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            Logger.getLogger(TopLevelDummyCreator.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    private void writeLine(String line) {
        try {
            this.writer.write(line);
            this.writer.write("\n");
        }
        catch (IOException ex) {
            System.err.println("Cannot write testbench");
        }
    }
}

