/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph;

import datapath.graph.Graph;
import datapath.graph.operations.Operation;

public class UseEdge
implements Comparable<UseEdge> {
    private Operation source;
    private Operation target;

    public UseEdge(Operation source, Operation target) {
        this.source = source;
        this.target = target;
    }

    public int distance() {
        return Graph.getDistance(this.source, this.target);
    }

    public boolean isBackedge() {
        return Graph.isBackEdge(this.source, this.target);
    }

    @Override
    public int compareTo(UseEdge o) {
        int otherDistance;
        int thisDistance = this.distance();
        if (thisDistance > (otherDistance = o.distance())) {
            return 1;
        }
        if (thisDistance < otherDistance) {
            return -1;
        }
        if (this.source.getNumber() > o.source.getNumber() || this.target.getNumber() > o.target.getNumber()) {
            return 1;
        }
        if (this.source.getNumber() < o.source.getNumber() || this.target.getNumber() < o.target.getNumber()) {
            return -1;
        }
        return 0;
    }

    public Operation getSource() {
        return this.source;
    }

    public Operation getTarget() {
        return this.target;
    }
}

