/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.display.dot;

import datapath.graph.display.Display;
import datapath.graph.display.dot.DisplayEdge;
import datapath.graph.display.dot.DisplayNode;
import datapath.graph.operations.Operation;
import datapath.graph.type.FixedPoint;
import datapath.graph.type.Type;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DotDisplay
extends Display<DisplayEdge, DisplayNode> {
    private HashSet<DisplayNode> nodes = new HashSet();
    private HashSet<DisplayEdge> edges = new HashSet();

    public DotDisplay(String name) {
        super(name);
    }

    @Override
    public void addNode(DisplayNode node) {
        this.nodes.add(node);
    }

    @Override
    public void addEdge(DisplayEdge edge) {
        this.edges.add(edge);
    }

    @Override
    public void display(String stage) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("junk_" + stage + ".dot"));
            out.write("digraph {\n");
            for (DisplayNode node : this.nodes) {
                Type t = node.getOperation().getType();
                if (t == null) {
                    t = new FixedPoint(0, 0, false);
                }
                String n = String.format("%s [label=\"%s %s Bits: %s Schedule: %d Cycles: %d\\nType: %s\\ndebug: %s\"];\n", node.getID(), node.getDisplayLabel(), node.getID(), t.getBitsize(), node.getOperation().getSchedule(), node.getOperation().getDelay(), t.toString().replace("\n", "\\n"), node.getOperation().getDebugMessage());
                out.write(n);
            }
            for (DisplayEdge edge : this.edges) {
                String n = String.format("%s -> %s;\n", ((DisplayNode)edge.getSource()).getID(), ((DisplayNode)edge.getTarget()).getID());
                out.write(n);
            }
            out.write("}\n");
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DotDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void display() {
        this.display("");
    }

    private HashMap<Integer, HashSet<DisplayNode>> getOperationScheduled() {
        HashMap<Integer, HashSet<DisplayNode>> map = new HashMap<Integer, HashSet<DisplayNode>>();
        for (DisplayNode n : this.nodes) {
            Operation op = n.getOperation();
            HashSet<DisplayNode> set = map.get(op.getSchedule());
            if (set == null) {
                set = new HashSet();
                map.put(op.getSchedule(), set);
            }
            set.add(n);
        }
        return map;
    }
}

