/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.operations;

import datapath.graph.OperationVisitor;
import datapath.graph.operations.Operation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AryOperation
extends Operation {
    protected Set<Operation> operands = new HashSet<Operation>();

    protected AryOperation() {
    }

    public void addOperand(Operation op) {
        assert (!this.operands.contains(op));
        this.operands.add(op);
        op.addUse(this);
    }

    public void removeOperand(Operation op) {
        assert (this.operands.contains(op));
        op.removeUse(this);
        this.operands.remove(op);
    }

    @Override
    public void replace(Operation oldOp, Operation newOp) {
        this.removeOperand(oldOp);
        this.addOperand(newOp);
    }

    public Set<Operation> getOperands() {
        return Collections.unmodifiableSet(this.operands);
    }

    @Override
    public void visit(OperationVisitor visitor) {
        visitor.visit(this);
    }
}

