/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.operations;

import datapath.graph.operations.Operation;
import java.util.HashSet;
import java.util.Set;

public abstract class BinaryOperation
extends Operation {
    protected Operation lhs;
    protected Operation rhs;

    public void setLHS(Operation op) {
        this.removeLHS();
        this.lhs = op;
        op.addUse(this);
    }

    public void setRHS(Operation op) {
        this.removeRHS();
        this.rhs = op;
        op.addUse(this);
    }

    public void removeLHS() {
        if (this.lhs != null) {
            this.lhs.removeUse(this);
            this.lhs = null;
        }
    }

    public void removeRHS() {
        if (this.rhs != null) {
            this.rhs.removeUse(this);
            this.rhs = null;
        }
    }

    public Operation getLhs() {
        return this.lhs;
    }

    public Operation getRhs() {
        return this.rhs;
    }

    @Override
    public void replace(Operation oldOp, Operation newOp) {
        assert (oldOp == this.lhs || oldOp == this.rhs);
        if (this.lhs == this.rhs && this.lhs == oldOp) {
            this.removeLHS();
            this.setLHS(newOp);
            this.setRHS(newOp);
        } else if (oldOp == this.lhs) {
            this.removeLHS();
            this.setLHS(newOp);
        } else {
            this.removeRHS();
            this.setRHS(newOp);
        }
    }

    @Override
    public Set<Operation> dependsOnOperations(boolean includeBackedges) {
        HashSet<Operation> ops = new HashSet<Operation>();
        ops.add(this.lhs);
        ops.add(this.rhs);
        return ops;
    }

    @Override
    public int getOutputBitsize() {
        if (this.getType() == null) {
            return this.lhs.getOutputBitsize();
        }
        return this.getType().getBitsize();
    }
}

