/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.operations;

import datapath.graph.OperationVisitor;
import datapath.graph.operations.ShiftMode;
import datapath.graph.operations.UnaryOperation;

public class ConstantShift
extends UnaryOperation {
    private int shiftAmount;
    private ShiftMode mode;

    public void setMode(ShiftMode mode) {
        this.mode = mode;
    }

    public ConstantShift(int shiftAmount, ShiftMode mode) {
        assert (shiftAmount >= 0);
        this.shiftAmount = shiftAmount;
        this.mode = mode;
    }

    @Override
    public int getOutputBitsize() {
        return this.getData().getOutputBitsize();
    }

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public int getStageDelay() {
        return 0;
    }

    @Override
    public String getDisplayLabel() {
        ShiftMode m = this.mode;
        switch (m) {
            case Right: {
                m = this.isSigned() ? ShiftMode.SignedRight : ShiftMode.UnsignedRight;
            }
        }
        switch (m) {
            case Left: {
                return "<< " + this.shiftAmount;
            }
            case SignedRight: {
                return ">>> " + this.shiftAmount;
            }
            case UnsignedRight: {
                return ">> " + this.shiftAmount;
            }
        }
        return "shift mode " + (Object)((Object)this.mode) + " not supported";
    }

    public void setShiftAmount(int shiftAmount) {
        this.shiftAmount = shiftAmount;
    }

    @Override
    public void visit(OperationVisitor visitor) {
        visitor.visit(this);
    }

    public ShiftMode getMode() {
        return this.mode;
    }

    public int getShiftAmount() {
        return this.shiftAmount;
    }
}

