/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.operations;

import datapath.graph.ModlibWriter;
import datapath.graph.OperationVisitor;
import datapath.graph.operations.BinaryOperation;
import datapath.graph.type.Float;
import datapath.graph.type.Type;

public class Multiplication
extends BinaryOperation {
    @Override
    public String getDisplayLabel() {
        return "MULT";
    }

    @Override
    public void visit(OperationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getDelay() {
        Type type = this.getType();
        int delay = super.getDelay();
        if (type instanceof Float) {
            int n = delay = type.getBitsize() == 32 ? 8 : 10;
        }
        if (ModlibWriter.mul_pipe) {
            if (ModlibWriter.mul_pipe_create) {
                if (this.lhs.getOutputBitsize() <= 64 && this.rhs.getOutputBitsize() <= 64 && this.getOutputBitsize() <= 128) {
                    delay = 32 - Integer.numberOfLeadingZeros((this.lhs.getOutputBitsize() + 15) / 16 - 1) + 32 - Integer.numberOfLeadingZeros((this.rhs.getOutputBitsize() + 15) / 16 - 1) + 2;
                    assert (delay > 0);
                    assert (delay < 20) : String.format("delay %d < 20 violated | %d * %d ", delay, this.lhs.getOutputBitsize(), this.rhs.getOutputBitsize());
                    return delay;
                }
            } else {
                if (this.lhs.getOutputBitsize() == 21 && this.rhs.getOutputBitsize() == 21 && this.getOutputBitsize() == 42) {
                    return 4;
                }
                if (this.lhs.getOutputBitsize() <= 16 && this.rhs.getOutputBitsize() <= 16 && this.getOutputBitsize() <= 32) {
                    return 2;
                }
                if (this.lhs.getOutputBitsize() <= 32 && this.rhs.getOutputBitsize() <= 32 && this.getOutputBitsize() <= 64) {
                    return 4;
                }
                if (this.lhs.getOutputBitsize() <= 64 && this.rhs.getOutputBitsize() <= 64 && this.getOutputBitsize() <= 128) {
                    return 6;
                }
            }
        }
        return delay;
    }

    @Override
    public int getStageDelay() {
        return super.getStageDelay();
    }
}

