/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.operations;

import datapath.graph.Graph;
import datapath.graph.OperationVisitor;
import datapath.graph.operations.AryOperation;
import datapath.graph.operations.Operation;
import datapath.graph.operations.Predication;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Mux
extends AryOperation {
    private Iterator<Operation> outputBitsizeIter = null;

    @Override
    public String getDisplayLabel() {
        return "MUX " + this.debugMessage;
    }

    @Override
    public void addOperand(Operation op) {
        assert (op instanceof Predication) : "Only Predication allowed as inputs of mux";
        super.addOperand(op);
    }

    @Override
    public Set<Operation> dependsOnOperations(boolean includeBackedges) {
        HashSet<Operation> ops = new HashSet<Operation>();
        for (Operation op : this.operands) {
            Predication p = (Predication)op;
            if (!includeBackedges && Graph.isBackEdge(op, this)) continue;
            ops.add(p);
        }
        return ops;
    }

    @Override
    public int getOutputBitsize() {
        if (this.getType() != null) {
            return this.getType().getBitsize();
        }
        if (this.operands.size() == 0) {
            return -1;
        }
        if (this.outputBitsizeIter == null) {
            this.outputBitsizeIter = this.operands.iterator();
        }
        int Bitsize = -1;
        if (this.outputBitsizeIter.hasNext()) {
            Bitsize = this.outputBitsizeIter.next().getOutputBitsize();
        }
        this.outputBitsizeIter = null;
        return Bitsize;
    }

    @Override
    public void visit(OperationVisitor visitor) {
        visitor.visit(this);
    }
}

