/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.operations;

import datapath.graph.OperationVisitor;
import datapath.graph.operations.Predicate;
import datapath.graph.type.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Operation {
    private Set<Operation> usage = new HashSet<Operation>();
    private Set<Predicate> predicates = new HashSet<Predicate>();
    private static int lastOp = 0;
    private int number = lastOp++;
    private int executionOrdinal;
    private int schedule = -1;
    private boolean executionOrdinalSet = false;
    protected String debugMessage = "";
    private int visit;
    private static int nextVisit;
    private Type type;

    protected Operation() {
    }

    public boolean isHardwareOperation() {
        return true;
    }

    public static void nextVisit() {
        ++nextVisit;
    }

    public void setVisited() {
        this.visit = nextVisit;
    }

    public boolean isVisited() {
        return this.visit == nextVisit;
    }

    public abstract void replace(Operation var1, Operation var2);

    public void addUse(Operation op) {
        this.usage.add(op);
    }

    public int getSchedule() {
        return this.schedule;
    }

    public void setSchedule(int schedule) {
        this.schedule = schedule;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getExecutionOrdinal() {
        return this.executionOrdinal;
    }

    public void setExecutionOrdinal(int executionOrdinal) {
        this.executionOrdinal = executionOrdinal;
        this.executionOrdinalSet = true;
    }

    public void addPredicate(Predicate pred) {
        this.predicates.add(pred);
        pred.addUse(this);
    }

    public void removeUse(Operation op) {
        this.usage.remove(op);
    }

    public String getDisplayName() {
        return "OP" + this.number + ":" + (this.executionOrdinalSet ? Integer.valueOf(this.executionOrdinal) : "-1") + ":" + this.getOutputBitsize() + "bit:" + this.schedule;
    }

    public int getNumber() {
        return this.number;
    }

    public String getDisplayLabel() {
        return this.getClass().getName();
    }

    public String toString() {
        return "OP" + this.number + " " + this.getDisplayLabel();
    }

    public Set<Operation> getUse() {
        return Collections.unmodifiableSet(this.usage);
    }

    @Deprecated
    public Set<Operation> getUse(boolean skipControl) {
        HashSet<Operation> use = new HashSet<Operation>();
        for (Operation op : this.usage) {
            if (!skipControl || op.isHardwareOperation()) {
                use.add(op);
                continue;
            }
            use.addAll(op.getUse(skipControl));
        }
        return use;
    }

    public Set<Predicate> getPredicates() {
        return this.predicates;
    }

    public void setDebugMessage(String message) {
        this.debugMessage = message;
    }

    public String getDebugMessage() {
        return this.debugMessage;
    }

    public void visit(OperationVisitor visitor) {
        visitor.visit(this);
    }

    public void postOrderUpwardVisit(OperationVisitor visitor) {
        this.setVisited();
        for (Operation op : this.dependsOnOperations(true)) {
            if (op.isVisited()) continue;
            op.postOrderUpwardVisit(visitor);
        }
        this.visit(visitor);
    }

    public void postOrderDownwardVisit(OperationVisitor visitor) {
        this.setVisited();
        for (Operation op : this.getUse()) {
            if (op.isVisited()) continue;
            op.postOrderUpwardVisit(visitor);
        }
        this.visit(visitor);
    }

    public boolean isSigned() {
        if (this.type == null) {
            return false;
        }
        return this.type.isSigned();
    }

    public boolean isFixedDelay() {
        return true;
    }

    public int getDelay() {
        return 0;
    }

    public int getStageDelay() {
        return 1;
    }

    public int getOutputBitsize() {
        if (this.type == null) {
            return 0;
        }
        return this.type.getBitsize();
    }

    public abstract Set<Operation> dependsOnOperations(boolean var1);
}

