/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.operations;

import datapath.graph.OperationVisitor;
import datapath.graph.operations.Operation;
import java.util.HashSet;
import java.util.Set;

public abstract class UnaryOperation
extends Operation {
    private Operation data = null;

    public void setData(Operation op) {
        this.removeData();
        this.data = op;
        op.addUse(this);
    }

    public void removeData() {
        if (this.data != null) {
            this.data.removeUse(this);
            this.data = null;
        }
    }

    public Operation getData() {
        return this.data;
    }

    @Override
    public void replace(Operation oldOp, Operation newOp) {
        assert (oldOp == this.data);
        this.removeData();
        this.setData(newOp);
    }

    @Override
    public Set<Operation> dependsOnOperations(boolean includeBackedges) {
        HashSet<Operation> ops = new HashSet<Operation>();
        assert (this.data != null) : this.getClass() + "has no data set";
        ops.add(this.data);
        return ops;
    }

    @Override
    public void visit(OperationVisitor visitor) {
        visitor.visit(this);
    }
}

