/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.type;

import datapath.graph.operations.constValue.Value;
import datapath.graph.type.Type;

public class FixedPoint
extends Type {
    private int fractionlength;

    public int getIntBits() {
        int result = this.getBitsize() - this.fractionlength;
        if (this.isSigned()) {
            --result;
        }
        assert (result >= 0);
        return result;
    }

    public void setFractionlength(int fractionlength) {
        this.fractionlength = fractionlength;
    }

    public int getFractionlength() {
        return this.fractionlength;
    }

    public FixedPoint(int bitsize, int fractionlength, boolean signedness) {
        this.setFractionlength(fractionlength);
        this.setBitsize(bitsize);
        this.setSigned(signedness);
    }

    @Override
    public double getMaxValue() {
        int bits = this.getBitsize();
        if (this.isSigned()) {
            --bits;
        }
        double max = (double)((1L << (bits -= this.getFractionlength())) + 1L) - 1.0 / (double)(1 << this.fractionlength);
        return max;
    }

    @Override
    public double getMinValue() {
        double min = this.isSigned() ? -this.getMaxValue() - 1.0 : 0.0;
        return min;
    }

    @Override
    public String toHex(Value value) {
        Float f = (Float)value.getValue();
        long iv = (long)((double)f.floatValue() * Math.pow(2.0, this.fractionlength));
        for (int i = this.getBitsize(); i < 64; ++i) {
            iv &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return Long.toHexString(iv);
    }

    public String toString() {
        return new String(this.getBitsize() + "-bit " + (this.isSigned() ? "signed" : "unsigned") + "Fixed Point with " + this.getFractionlength() + " bit fraction\nValue Range: [" + this.getMinValue() + "..." + this.getMaxValue() + "]");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedPoint other = (FixedPoint)obj;
        return this.fractionlength == other.fractionlength;
    }

    public void restrictBitwidth(int maxBitwidth) {
        if (this.getBitsize() > maxBitwidth) {
            int diff = this.getBitsize() - maxBitwidth;
            this.setFractionlength(Math.max(0, this.getFractionlength() - diff));
            this.setBitsize(maxBitwidth);
        }
    }

    public void increaseFractionlength(int newBidwidth) {
        if (this.getBitsize() < newBidwidth) {
            int missing = newBidwidth - this.getBitsize();
            this.setBitsize(this.getBitsize() + missing);
            this.setFractionlength(this.getFractionlength() + missing);
        }
    }

    public void setToBitwidth(int newBidwith) {
        this.restrictBitwidth(newBidwith);
        this.increaseFractionlength(newBidwith);
    }
}

