/*
 * Decompiled with CFR 0.152.
 */
package datapath.graph.type;

import datapath.graph.operations.constValue.Value;
import datapath.graph.type.Type;

public class Float
extends Type {
    @Override
    public double getMaxValue() {
        double result;
        switch (this.getBitsize()) {
            case 16: {
                result = 3.4028234663852886E38;
                break;
            }
            case 32: {
                result = Double.MAX_VALUE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
        return result;
    }

    @Override
    public double getMinValue() {
        double result;
        switch (this.getBitsize()) {
            case 16: {
                result = 1.4E-45f;
                break;
            }
            case 32: {
                result = Double.MIN_VALUE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
        return result;
    }

    @Override
    public String toHex(Value value) {
        java.lang.Float f = (java.lang.Float)value.getValue();
        return Integer.toHexString(java.lang.Float.floatToRawIntBits(f.floatValue()));
    }

    public String toString() {
        return new String(this.getBitsize() + "-bit " + (this.isSigned() ? "signed" : "unsigned") + " Floating Point\nValue Range: [" + this.getMinValue() + "..." + this.getMaxValue() + "]");
    }
}

