/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.codegen_verilog;

import de.gaalop.CodeGenerator;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.codegen_verilog.VerilogIR.VerilogDFG;
import de.gaalop.cpp.CppVisitor;
import de.gaalop.optimizations.CSE.CSE_Collector;
import de.gaalop.optimizations.ConstantFolding;
import de.gaalop.optimizations.ConstantKiller.ConstanKillCrawler;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum VerilogCodegen implements CodeGenerator
{
    INSTANCE;


    public Set<OutputFile> generate(ControlFlowGraph in) {
        String code = this.generateCode(in);
        String filename = this.generateFilename(in);
        OutputFile sourceFile = new OutputFile(filename, code, Charset.forName("UTF-8"));
        return Collections.singleton(sourceFile);
    }

    private String generateFilename(ControlFlowGraph in) {
        String filename = "gaalop";
        if (in.getSource() != null) {
            filename = in.getSource().getName();
            int lastDotIndex = filename.lastIndexOf(46);
            if (lastDotIndex != -1) {
                filename = filename.substring(0, lastDotIndex);
            }
            filename = filename + ".v";
        }
        return filename;
    }

    private String generateCode(ControlFlowGraph in) {
        CppVisitor cpp = new CppVisitor(true);
        in.accept((ControlFlowVisitor)cpp);
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter("original.cpp"));
            w.write(cpp.getCode());
            w.flush();
            w.close();
        }
        catch (IOException ex) {
            Logger.getLogger(VerilogCodegen.class.getName()).log(Level.SEVERE, null, ex);
        }
        ConstantFolding cf = new ConstantFolding();
        in.accept((ControlFlowVisitor)cf);
        for (int i = 0; i < 20; ++i) {
            in.accept((ControlFlowVisitor)new ConstanKillCrawler());
            in.accept((ControlFlowVisitor)new ConstantFolding());
        }
        in.accept((ControlFlowVisitor)new CSE_Collector());
        in.accept((ControlFlowVisitor)new CSE_Collector());
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter("junk.cpp"));
            w.write(cpp.getCode());
            w.flush();
            w.close();
        }
        catch (IOException ex) {
            Logger.getLogger(VerilogCodegen.class.getName()).log(Level.SEVERE, null, ex);
        }
        VerilogDFG mydfg = new VerilogDFG(in);
        System.out.println(in.toString());
        return mydfg.getIrvisit().getResult();
    }
}

