/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.codegen_verilog.VerilogIR;

public class FPValue {
    private int fractionlength;
    private int wordlength;
    private int binarypointposition;
    private long binaryvalue;
    private long one = 1L;
    private long signcheck = this.one << 63;
    private boolean negative;

    public FPValue(double f, int length, int fraction) {
        this.fractionlength = fraction + 1;
        this.wordlength = length;
        this.binarypointposition = fraction + 1;
        long l = (long)(f * Math.pow(2.0, fraction + 1));
        this.negative = (this.signcheck & l) >>> 63 == this.one;
        long sl = l << 63 - length;
        if (!this.negative) {
            this.binaryvalue = sl >>> 63 - length;
        } else {
            sl = sl >>> 1 | this.signcheck;
            this.binaryvalue = sl >> 63 - length - 1;
        }
    }

    public double getFloat() {
        return (double)this.binaryvalue / Math.pow(2.0, this.fractionlength);
    }

    public long getBinaryvalue64() {
        return this.binaryvalue;
    }

    public int getBinaryvalue32() {
        return (int)this.binaryvalue;
    }

    public String getHexString32() {
        int r = this.getBinaryvalue32();
        return Integer.toHexString(r);
    }

    public String getHexString64() {
        return Long.toHexString(this.binaryvalue);
    }

    public void setBinaryvalue(long binaryvalue) {
        this.binaryvalue = binaryvalue;
    }

    public String getFullString() {
        return this.getBitSubString(this.binaryvalue, this.fractionlength, 63) + " . " + this.getBitSubString(this.binaryvalue, 0, this.fractionlength - 1);
    }

    public String getBitSubString(long value, int pos1, int pos2) {
        long t = 1L;
        long displayMask = t << pos2;
        StringBuffer buf = new StringBuffer(100);
        for (int c = pos1; c <= pos2; ++c) {
            buf.append((value & displayMask) == 0L ? (char)'0' : '1');
            displayMask >>>= 1;
            if (c % 8 != 0) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public int getFractionlength() {
        return this.fractionlength;
    }

    public void setFractionlength(int fractionlength) {
        this.fractionlength = fractionlength;
    }

    public int getWordlength() {
        return this.wordlength;
    }

    public int getBinarypointposition() {
        return this.binarypointposition;
    }

    public void setBinarypointposition(int binarypointposition) {
        this.binarypointposition = binarypointposition;
    }

    public boolean isNegative() {
        return this.negative;
    }
}

