/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.codegen_verilog.VerilogIR;

import datapath.graph.DeadTreeElimination;
import datapath.graph.Graph;
import datapath.graph.GreedySchedule;
import datapath.graph.ModlibWriter;
import datapath.graph.Schedule;
import datapath.graph.TestbenchCreator;
import datapath.graph.display.DisplayFactory;
import datapath.graph.display.dot.DotDisplayFactory;
import datapath.graph.operations.Absolut;
import datapath.graph.operations.Add;
import datapath.graph.operations.ArcCos;
import datapath.graph.operations.ConstantMultiplication;
import datapath.graph.operations.ConstantOperation;
import datapath.graph.operations.ConstantShift;
import datapath.graph.operations.Cos;
import datapath.graph.operations.Divide;
import datapath.graph.operations.HWInput;
import datapath.graph.operations.HWOutput;
import datapath.graph.operations.LoopEnd;
import datapath.graph.operations.LoopInit;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentOutput;
import datapath.graph.operations.Predicate;
import datapath.graph.operations.ShiftMode;
import datapath.graph.operations.Sin;
import datapath.graph.operations.SquareRoot;
import datapath.graph.operations.Subtraction;
import datapath.graph.operations.TopLevelInput;
import datapath.graph.operations.UnaryOperation;
import datapath.graph.operations.constValue.FloatValue;
import datapath.graph.type.FixedPoint;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.codegen_verilog.VerilogIR.VerilogDFG;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Variable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import wordlengthoptimization.Options;
import wordlengthoptimization.Util;
import wordlengthoptimization.WordLengthGUI;
import wordlengthoptimization.WordlengthOptimization;

public class VerilogIRConverterVisitorCookies
implements ExpressionVisitor,
ControlFlowVisitor {
    private HashMap<AssignmentNode, Operation> assginmentToOperation = new HashMap();
    private HashMap<String, AssignmentNode> stringToAssignmentNode = new HashMap();
    private HashMap<Variable, TopLevelInput> variableToHWInput = new HashMap();
    private Graph g = new Graph();
    private ControlFlowGraph formerGraph;
    String result;
    String lastcomponent;
    Operation toappend;
    VerilogDFG dfg;
    boolean isVariable = true;
    private static final int ADDITION = 1;
    private static final int SUBTRACTION = 2;
    private static final int MULTIPLICATION = 3;
    private static final int MULTIPLICATION_const = 7;
    private static final int DIVISION = 4;
    private static final int EXPONENTIATION = 5;
    private static final int EXPONENTIATIONSquare = 6;
    private LoopInit l;
    private boolean mathfunctionHack;

    public VerilogIRConverterVisitorCookies(VerilogDFG dfg) {
        this.dfg = dfg;
        System.out.println("Starting VerilogIR Converter");
    }

    public String getResult() {
        return this.result;
    }

    public void visit(de.gaalop.dfg.Subtraction node) {
        System.out.println("MySubVisit");
        this.visitbinary((BinaryOperation)node, 2);
    }

    public void visit(Relation rel) {
        System.err.println("Relation in VerilogIRConverterVisitorCookies not yet supported!");
    }

    public void visit(Inequality inequal) {
        System.err.println("Inequality in VerilogIRConverterVisitorCookies not yet supported!");
    }

    public void visit(Equality equal) {
        System.err.println("Equality in VerilogIRConverterVisitorCookies not yet supported!");
    }

    public void visit(LogicalAnd logand) {
        System.err.println("LogicalAnd in VerilogIRConverterVisitorCookies not yet supported!");
    }

    public void visit(LogicalOr logand) {
        System.err.println("LogicalOr in VerilogIRConverterVisitorCookies not yet supported!");
    }

    public void visit(BlockEndNode node) {
        System.err.println("BlockEndNode in VerilogIRConverterVisitorCookies not yet supported!");
    }

    public void visit(IfThenElseNode node) {
        System.err.println("IfThenElseNode in VerilogIRConverterVisitorCookies not yet supported!");
    }

    public void visitbinary(BinaryOperation node, int operation) {
        System.out.println("MyBinaryVisit");
        node.getLeft().accept((ExpressionVisitor)this);
        Operation lhs = this.toappend;
        node.getRight().accept((ExpressionVisitor)this);
        Operation rhs = this.toappend;
        switch (operation) {
            case 1: {
                this.toappend = new Add();
                break;
            }
            case 2: {
                System.out.println("subtraction");
                this.toappend = new Subtraction();
                break;
            }
            case 3: {
                this.toappend = new datapath.graph.operations.Multiplication();
                break;
            }
            case 7: {
                this.toappend = new ConstantMultiplication();
                break;
            }
            case 4: {
                Variable v;
                this.toappend = new Divide();
                if (!(node.getRight() instanceof Variable) || !(v = (Variable)node.getRight()).getName().toLowerCase().contains("norm")) break;
                System.out.println("Normalisation detected");
                break;
            }
            default: {
                System.err.println("not supported Binary Operation: " + operation);
                assert (false);
                break;
            }
        }
        ((datapath.graph.operations.BinaryOperation)this.toappend).setLHS(lhs);
        ((datapath.graph.operations.BinaryOperation)this.toappend).setRHS(rhs);
        this.addToGraph(this.toappend);
    }

    public void visit(Addition node) {
        System.out.println("MyAddVisit");
        this.visitbinary((BinaryOperation)node, 1);
    }

    public void visit(Division node) {
        System.out.println("MyDivVisit");
        if (this.isPowerOf2(node.getRight())) {
            int toshift = Integer.numberOfTrailingZeros((int)((FloatConstant)node.getRight()).getValue());
            node.getLeft().accept((ExpressionVisitor)this);
            Operation tobedivided = this.toappend;
            ConstantShift cs = new ConstantShift(toshift, ShiftMode.Right);
            cs.setData(tobedivided);
            this.toappend = cs;
            this.addToGraph(cs);
        } else {
            this.visitbinary((BinaryOperation)node, 4);
        }
    }

    public void visit(InnerProduct node) {
    }

    private boolean isSquare(Exponentiation exponentiation) {
        FloatConstant two = new FloatConstant(2.0);
        return two.equals((Object)exponentiation.getRight());
    }

    private boolean isSqrt(Exponentiation exp) {
        Division div;
        FloatConstant one = new FloatConstant(1.0);
        FloatConstant two = new FloatConstant(2.0);
        FloatConstant half = new FloatConstant(0.5);
        if (exp.getRight() instanceof FloatConstant) {
            return exp.getRight().equals(half);
        }
        return exp.getRight() instanceof Division && (div = (Division)exp.getRight()).getLeft().equals(one) && div.getRight().equals(two);
    }

    public void visit(Multiplication node) {
        System.out.println("MyMultVisit");
        if (this.isPowerOf2(node.getLeft())) {
            int toshift = Integer.numberOfTrailingZeros((int)((FloatConstant)node.getLeft()).getValue());
            node.getRight().accept((ExpressionVisitor)this);
            Operation rhs = this.toappend;
            ConstantShift cs = new ConstantShift(toshift, ShiftMode.Left);
            cs.setData(rhs);
            this.toappend = cs;
            this.addToGraph(cs);
        } else if (this.isPowerOf2(node.getRight())) {
            int toshift = Integer.numberOfTrailingZeros((int)((FloatConstant)node.getRight()).getValue());
            node.getLeft().accept((ExpressionVisitor)this);
            Operation lhs = this.toappend;
            ConstantShift cs = new ConstantShift(toshift, ShiftMode.Left);
            cs.setData(lhs);
            this.toappend = cs;
            this.addToGraph(cs);
        } else {
            this.visitbinary((BinaryOperation)node, 3);
        }
    }

    public boolean isPowerOf2(Expression node) {
        if (node instanceof FloatConstant) {
            double f = ((FloatConstant)node).getValue();
            int fi = (int)((FloatConstant)node).getValue();
            return fi >= 2 && f == (double)fi && Integer.bitCount(fi) == 1;
        }
        return false;
    }

    public void visit(MathFunctionCall node) {
        UnaryOperation newOp;
        System.out.println("MyMathFuncVisit");
        this.mathfunctionHack = true;
        node.getOperand().accept((ExpressionVisitor)this);
        this.mathfunctionHack = false;
        switch (node.getFunction()) {
            case SQRT: {
                newOp = new SquareRoot();
                break;
            }
            case ABS: {
                newOp = new Absolut();
                break;
            }
            case ACOS: {
                newOp = new ArcCos();
                break;
            }
            case COS: {
                newOp = new Cos();
                break;
            }
            case SIN: {
                newOp = new Sin();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Math function " + node.toString() + " not supported.");
            }
        }
        newOp.setData(this.toappend);
        this.toappend = newOp;
        this.addToGraph(this.toappend);
    }

    public void visit(Variable exnode) {
        System.out.println("MyExpression/VariableNodeVisit Eingangswerte " + exnode.getName());
        this.lastcomponent = exnode.getName();
        if (this.mathfunctionHack && !this.lastcomponent.contains("CSE")) {
            this.lastcomponent = this.lastcomponent + "0";
        }
        if (this.variableToHWInput.containsKey(exnode)) {
            this.toappend = this.variableToHWInput.get(exnode);
        } else if (!this.isVariable && this.getAssignmentToOperationMap().get(this.getStringToAssignment().get(this.lastcomponent)) != null) {
            this.toappend = this.getAssignmentToOperationMap().get(this.getStringToAssignment().get(this.lastcomponent));
        } else if (!this.isVariable) {
            System.out.println(this.variableToHWInput);
            System.out.println("");
            System.out.println(this.getStringToAssignment().keySet());
            assert (false) : "should not happen " + exnode + " " + this.lastcomponent;
        }
    }

    public void visit(MultivectorComponent mc) {
        System.out.println("MyComponentVisit");
        StringBuilder temp = new StringBuilder();
        temp.append(mc.getName());
        temp.append(mc.getBladeIndex());
        this.lastcomponent = temp.toString();
        System.out.println(this.lastcomponent);
        this.toappend = null;
        if (!this.isVariable) {
            this.toappend = this.getAssignmentToOperationMap().get(this.getStringToAssignment().get(this.lastcomponent));
        }
    }

    public void visit(Exponentiation exnode) {
        System.out.println("MyExponentiationNodeVisit");
        if (this.isSqrt(exnode)) {
            System.out.println("found stupid other sqrt");
            SquareRoot newOp = new SquareRoot();
            exnode.getLeft().accept((ExpressionVisitor)this);
            assert (this.toappend != null);
            newOp.setData(this.toappend);
            this.toappend = newOp;
        } else {
            assert (exnode.getRight() instanceof FloatConstant);
            FloatConstant c = (FloatConstant)exnode.getRight();
            assert (c.getValue() - (double)Double.valueOf(c.getValue()).intValue() == 0.0);
            int exponent = (int)c.getValue();
            assert (exponent >= 2) : "assert exponent >= 2 error: exponent=" + exponent;
            exnode.getLeft().accept((ExpressionVisitor)this);
            assert (this.toappend != null);
            Operation op = this.toappend;
            datapath.graph.operations.Multiplication lastM = new datapath.graph.operations.Multiplication();
            lastM.setLHS(op);
            lastM.setRHS(op);
            exponent -= 2;
            while (exponent > 0) {
                datapath.graph.operations.Multiplication newM = new datapath.graph.operations.Multiplication();
                newM.setRHS(lastM);
                newM.setLHS(op);
                lastM = newM;
                this.addToGraph(newM);
                --exponent;
            }
            this.toappend = lastM;
        }
        assert (this.toappend != null);
        this.addToGraph(this.toappend);
    }

    public void visit(FloatConstant fcnode) {
        System.out.println("MyFloatConstantVisit");
        FloatValue value = new FloatValue();
        value.setValue(Float.valueOf(Float.valueOf((float)fcnode.getValue()).floatValue()));
        ConstantOperation co = new ConstantOperation(value, fcnode.toString());
        co.setOutputBitsize(32);
        this.toappend = co;
        this.addToGraph(this.toappend);
    }

    public void visit(OuterProduct opnode) {
        throw new UnsupportedOperationException("The Verilog backend does not support Outer Products");
    }

    public void visit(BaseVector node) {
        throw new UnsupportedOperationException("The Verilog backend does not support base vectors.");
    }

    public void visit(Negation node) {
        System.out.println("MyNegationVisit");
        node.getOperand().accept((ExpressionVisitor)this);
        datapath.graph.operations.Negation n = new datapath.graph.operations.Negation();
        n.setData(this.toappend);
        this.toappend = n;
        this.addToGraph(this.toappend);
    }

    public void visit(Reverse node) {
        throw new UnsupportedOperationException("The Verilog backend does not support the reverse operation.");
    }

    public void visit(StartNode node) {
        System.out.println("MyStartVisit");
        this.formerGraph = node.getGraph();
        this.l = new LoopInit();
        LoopEnd le = new LoopEnd();
        Predicate x = new Predicate(Predicate.TYPE.INIT);
        le.addPredicate(x);
        x.setData(this.l);
        this.g.addOperation(this.l);
        this.g.addOperation(x);
        this.g.addOperation(le);
        for (Variable exnode : node.getGraph().getInputVariables()) {
            HWInput hw = new HWInput(exnode);
            TopLevelInput top = new TopLevelInput();
            top.setSource(hw);
            top.setName(exnode.getName());
            if (exnode.getMinValue() != null) {
                double min = Double.parseDouble(exnode.getMinValue());
                double max = Double.parseDouble(exnode.getMaxValue());
                int prec = Math.max(Util.bitsRequiredForFraction(exnode.getMinValue()), Util.bitsRequiredForFraction(exnode.getMaxValue()));
                hw.setType(new FixedPoint(Util.bitsRequired(min, max) + prec, prec, min < 0.0));
                top.setType(hw.getType());
            }
            this.addToGraph(hw);
            this.addToGraph(top);
            System.out.println("adding InputVariable " + exnode);
            this.variableToHWInput.put(exnode, top);
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        System.out.println("MyAssignmentVisit");
        this.isVariable = true;
        System.out.println("---------Getting Variable----------");
        node.getVariable().accept((ExpressionVisitor)this);
        this.getStringToAssignment().put(this.lastcomponent, node);
        String debug = this.lastcomponent;
        this.isVariable = false;
        System.out.println("---------Getting Value----------");
        node.getValue().accept((ExpressionVisitor)this);
        assert (this.toappend != null) : "toappend nicht null";
        this.getAssignmentToOperationMap().put(node, this.toappend);
        this.toappend.setDebugMessage(debug);
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        System.out.println("MyStoreResultVisit");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        System.out.println("Fertig mit Graph");
        for (Map.Entry<AssignmentNode, Operation> iterable_element : this.assginmentToOperation.entrySet()) {
            HWOutput out = new HWOutput();
            out.setName(iterable_element.getKey().getVariable().toString().replace("[", "").replace("]", ""));
            out.setData(iterable_element.getValue());
            Predicate ptemp = new Predicate(Predicate.TYPE.INIT);
            this.g.addOperation(ptemp);
            ptemp.setData(this.l);
            out.addPredicate(ptemp);
            this.g.addOperation(out);
        }
        GreedySchedule s = new GreedySchedule();
        Options opts = new Options();
        opts.setStartVariableMinValues(this.formerGraph.getPragmaMinValue());
        opts.setStartVariableMaxValues(this.formerGraph.getPragmaMaxValue());
        opts.setOutputVariables(this.formerGraph.getPragmaOutputVariables());
        DeadTreeElimination dte = new DeadTreeElimination(this.g, opts.getOutputVariables());
        dte.perform();
        WordLengthGUI dialog = new WordLengthGUI(null, true, opts);
        dialog.setVisible(true);
        WordlengthOptimization w = opts.getSelectedOptimizer();
        w.setOptions(opts);
        System.out.println("Wordlength optimization (" + w + ") finished. Changed " + w.optimize(this.g) + " nodes");
        Util.fixHWInputs(this.g);
        ((Schedule)s).scheduleAll(this.g);
        this.g.display(new DotDisplayFactory());
        for (ParentOutput out : this.g.getOutput()) {
            System.out.println("building graph for " + out.getName());
            this.g.display((DisplayFactory)new DotDisplayFactory(), out);
        }
        try {
            StringWriter x = new StringWriter();
            ModlibWriter.write(this.g, new BufferedWriter(new FileWriter("testoutput.v")));
            ModlibWriter.write(this.g, new BufferedWriter(x));
            this.result = x.toString();
            TestbenchCreator.writeTestbench(this.g, new BufferedWriter(new FileWriter("testbench.v")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HashMap<AssignmentNode, Operation> getAssignmentToOperationMap() {
        return this.assginmentToOperation;
    }

    public HashMap<String, AssignmentNode> getStringToAssignment() {
        return this.stringToAssignmentNode;
    }

    public void addToGraph(Operation n) {
        assert (n != null);
        System.out.println("Adding Node to CookieGraph: " + n.getClass().getSimpleName());
        this.g.addOperation(n);
    }

    public void visit(LogicalNegation node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(FunctionArgument node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(MacroCall node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LoopNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(BreakNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Macro node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ExpressionStatement node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ColorNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

