/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.optimizations.CSE;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import de.gaalop.optimizations.CSE.OperationStore;
import de.gaalop.optimizations.CSE.OperationToken;

public class CSE_Replacer
implements ExpressionVisitor,
ControlFlowVisitor {
    Expression nx;
    ControlFlowGraph cfg;
    OperationStore opstor;

    public CSE_Replacer(OperationStore opstor) {
        this.opstor = opstor;
    }

    public void visit(Subtraction node) {
        if (this.opstor.OperationShouldBeReplaced((Expression)node)) {
            this.nx = new Variable(this.opstor.getReplacementID((Expression)node));
            System.out.println("Replacer: Node  in Set: (  " + node.toString() + "  )     ---> Replacing with " + this.opstor.getReplacementID((Expression)node));
        } else {
            node.getLeft().accept((ExpressionVisitor)this);
            Expression lhs = this.nx;
            node.getRight().accept((ExpressionVisitor)this);
            Expression rhs = this.nx;
            this.nx = new Subtraction(lhs, rhs);
        }
    }

    public void visit(Addition node) {
        if (this.opstor.OperationShouldBeReplaced((Expression)node)) {
            this.nx = new Variable(this.opstor.getReplacementID((Expression)node));
            System.out.println("Replacer: Node  in Set: (  " + node.toString() + "  )    ---> Replacing with " + this.opstor.getReplacementID((Expression)node));
        } else {
            node.getLeft().accept((ExpressionVisitor)this);
            Expression lhs = this.nx;
            node.getRight().accept((ExpressionVisitor)this);
            Expression rhs = this.nx;
            this.nx = new Addition(lhs, rhs);
        }
    }

    public void visit(Division node) {
        if (this.opstor.OperationShouldBeReplaced((Expression)node)) {
            this.nx = new Variable(this.opstor.getReplacementID((Expression)node));
            System.out.println("Replacer: Node  in Set: (  " + node.toString() + "  )     ---> Replacing with " + this.opstor.getReplacementID((Expression)node));
        } else {
            node.getLeft().accept((ExpressionVisitor)this);
            Expression lhs = this.nx;
            node.getRight().accept((ExpressionVisitor)this);
            Expression rhs = this.nx;
            this.nx = new Division(lhs, rhs);
        }
    }

    public void visit(InnerProduct node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Multiplication node) {
        if (this.opstor.OperationShouldBeReplaced((Expression)node)) {
            this.nx = new Variable(this.opstor.getReplacementID((Expression)node));
            System.out.println("Replacer: Node  in Set: (  " + node.toString() + "  )    ---> Replacing with " + this.opstor.getReplacementID((Expression)node));
        } else {
            node.getLeft().accept((ExpressionVisitor)this);
            Expression lhs = this.nx;
            node.getRight().accept((ExpressionVisitor)this);
            Expression rhs = this.nx;
            this.nx = new Multiplication(lhs, rhs);
        }
    }

    public void visit(MathFunctionCall node) {
        if (this.opstor.OperationShouldBeReplaced((Expression)node)) {
            this.nx = new Variable(this.opstor.getReplacementID((Expression)node));
            System.out.println("Replacer: Node  in Set: (  " + node.toString() + "  )    ---> Replacing with " + this.opstor.getReplacementID((Expression)node));
        } else {
            node.getOperand().accept((ExpressionVisitor)this);
            this.nx = new MathFunctionCall(this.nx, node.getFunction());
        }
    }

    public void visit(Variable node) {
        this.nx = node;
    }

    public void visit(MultivectorComponent node) {
        this.nx = node;
    }

    public void visit(Exponentiation node) {
        if (this.isSquare(node)) {
            Multiplication nodeMul = new Multiplication(node.getLeft(), node.getLeft());
            this.nx = nodeMul;
            if (this.opstor.OperationShouldBeReplaced((Expression)nodeMul)) {
                this.nx = new Variable(this.opstor.getReplacementID((Expression)nodeMul));
            }
        } else if (this.opstor.OperationShouldBeReplaced((Expression)node)) {
            this.nx = new Variable(this.opstor.getReplacementID((Expression)node));
            System.out.println("Replacer: Node  in Set: (  " + node.toString() + "  )    ---> Replacing with " + this.opstor.getReplacementID((Expression)node));
        } else {
            node.getLeft().accept((ExpressionVisitor)this);
            Expression lhs = this.nx;
            node.getRight().accept((ExpressionVisitor)this);
            Expression rhs = this.nx;
            this.nx = new Exponentiation(lhs, rhs);
        }
    }

    public void visit(FloatConstant node) {
        this.nx = node;
    }

    public void visit(OuterProduct node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(BaseVector node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        this.nx = new Negation(this.nx);
    }

    public void visit(Reverse node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LogicalOr node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LogicalAnd node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Equality node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Inequality node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Relation relation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(StartNode node) {
        System.out.println("Replacer: Starting CSE Replacement");
        this.cfg = node.getGraph();
        for (OperationToken iterable_element : this.opstor.ReplaceAbleOpsSet.values()) {
            this.cfg.addLocalVariable(new Variable(iterable_element.getIdentifier()));
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        System.out.println("Replacer : Assginment Node " + node.getVariable().toString() + " visited------------------------------------");
        node.getValue().accept((ExpressionVisitor)this);
        node.setValue(this.nx);
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BlockEndNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        System.out.println("Replacer: CSE Replacement beendet");
    }

    private boolean isSquare(Exponentiation exponentiation) {
        FloatConstant two = new FloatConstant(2.0);
        return two.equals((Object)exponentiation.getRight());
    }

    public void visit(LogicalNegation node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(FunctionArgument node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(MacroCall node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LoopNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(BreakNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Macro node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ExpressionStatement node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ColorNode colorNode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

