/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.optimizations;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;

public class ConstantFolding
implements ExpressionVisitor,
ControlFlowVisitor {
    private Expression resultExpr;

    public void visit(Subtraction node) {
        FloatConstant rightc;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Subtraction(left, right);
        if (left instanceof FloatConstant && right instanceof FloatConstant) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc2 = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() - rightc2.getValue());
        } else if (right instanceof Negation) {
            Negation neg = (Negation)right;
            this.resultExpr = new Addition(left, neg.getOperand());
        } else if (left instanceof FloatConstant) {
            FloatConstant leftc = (FloatConstant)left;
            if (leftc.getValue() == 0.0) {
                this.resultExpr = new Negation(right);
            }
        } else if (right instanceof FloatConstant && (rightc = (FloatConstant)right).getValue() == 0.0) {
            this.resultExpr = left;
        }
    }

    public void visit(Addition node) {
        FloatConstant rightc;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Addition(left, right);
        if (left instanceof FloatConstant && right instanceof FloatConstant) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc2 = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() + rightc2.getValue());
        } else if (left instanceof FloatConstant) {
            FloatConstant leftc = (FloatConstant)left;
            if (leftc.getValue() == 0.0) {
                this.resultExpr = right;
            }
        } else if (right instanceof FloatConstant && (rightc = (FloatConstant)right).getValue() == 0.0) {
            this.resultExpr = left;
        }
    }

    public void visit(Division node) {
        FloatConstant floatConst;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = left instanceof FloatConstant && ((FloatConstant)left).getValue() == 1.0 ? new Division(left, right) : new Multiplication(left, (Expression)new Division((Expression)new FloatConstant("1.0"), right));
        if (left instanceof FloatConstant && right instanceof FloatConstant) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() / rightc.getValue());
        } else if (node.getRight() instanceof FloatConstant && (floatConst = (FloatConstant)node.getRight()).getValue() == 1.0) {
            this.resultExpr = left;
        }
    }

    public void visit(InnerProduct node) {
        this.resultExpr = node;
    }

    public void visit(Multiplication node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Multiplication(left, right);
        if (left instanceof FloatConstant && right instanceof FloatConstant) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() * rightc.getValue());
        } else if (right instanceof FloatConstant) {
            FloatConstant floatConst = (FloatConstant)right;
            if (floatConst.getValue() == 1.0) {
                this.resultExpr = left;
            } else if (floatConst.getValue() == 0.5) {
                this.resultExpr = new Division(left, (Expression)new FloatConstant(2.0));
            } else if (floatConst.getValue() == -1.0) {
                this.resultExpr = new Negation(left);
            } else if (floatConst.getValue() == 0.0) {
                this.resultExpr = right;
            }
        } else if (left instanceof FloatConstant) {
            FloatConstant floatConst = (FloatConstant)left;
            if (floatConst.getValue() == 1.0) {
                this.resultExpr = right;
            } else if (floatConst.getValue() == 0.5) {
                this.resultExpr = new Division(right, (Expression)new FloatConstant(2.0));
            } else if (floatConst.getValue() == -1.0) {
                this.resultExpr = new Negation(right);
            } else if (floatConst.getValue() == 0.0) {
                this.resultExpr = left;
            }
        } else if (left instanceof MathFunctionCall && right instanceof MathFunctionCall) {
            MathFunctionCall leftFunc = (MathFunctionCall)left;
            MathFunctionCall rightFunc = (MathFunctionCall)right;
            if (leftFunc.getFunction() == MathFunction.ABS && rightFunc.getFunction() == MathFunction.ABS) {
                this.resultExpr = new MathFunctionCall((Expression)new Multiplication(rightFunc.getOperand(), leftFunc.getOperand()), MathFunction.ABS);
            }
            if (leftFunc.getFunction() == MathFunction.SQRT && rightFunc.getFunction() == MathFunction.SQRT) {
                this.resultExpr = new MathFunctionCall((Expression)new Multiplication(rightFunc.getOperand(), leftFunc.getOperand()), MathFunction.SQRT);
            }
        }
    }

    public void visit(MathFunctionCall node) {
        node.getOperand().accept((ExpressionVisitor)this);
        Expression previousExpr = this.resultExpr;
        this.resultExpr = new MathFunctionCall(previousExpr, node.getFunction());
        if (node.getFunction() == MathFunction.SQRT && previousExpr instanceof FloatConstant) {
            FloatConstant operand = (FloatConstant)previousExpr;
            this.resultExpr = new FloatConstant(Math.sqrt(operand.getValue()));
        } else if (node.getFunction() == MathFunction.ABS && previousExpr instanceof MathFunctionCall) {
            MathFunctionCall insideFunc = (MathFunctionCall)previousExpr;
            if (insideFunc.getFunction() == MathFunction.ABS || insideFunc.getFunction() == MathFunction.SQRT) {
                this.resultExpr = previousExpr;
            }
        } else if (!(node.getFunction() != MathFunction.SQRT || previousExpr instanceof MathFunctionCall && ((MathFunctionCall)previousExpr).getFunction() == MathFunction.ABS)) {
            this.resultExpr = new MathFunctionCall((Expression)new MathFunctionCall(previousExpr, MathFunction.ABS), MathFunction.SQRT);
        }
    }

    public void visit(Variable node) {
        this.resultExpr = node;
    }

    public void visit(MultivectorComponent node) {
        this.resultExpr = node;
    }

    public void visit(Exponentiation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Exponentiation(left, right);
        if (left instanceof FloatConstant && right instanceof FloatConstant) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = new FloatConstant((double)Float.valueOf((float)Math.pow(leftc.getValue(), rightc.getValue())).floatValue());
        } else if (left instanceof FloatConstant && ((FloatConstant)left).getValue() == 0.0) {
            this.resultExpr = left;
        } else if (right instanceof FloatConstant) {
            MathFunctionCall newsqrt;
            boolean isSqrt;
            FloatConstant rightc = (FloatConstant)right;
            boolean bl = isSqrt = rightc.getValue() - (double)Double.valueOf(rightc.getValue()).intValue() == 0.5;
            if (isSqrt && rightc.getValue() != 0.5) {
                newsqrt = new MathFunctionCall((Expression)new Exponentiation(left, (Expression)new FloatConstant(rightc.getValue() - 0.5)), MathFunction.SQRT);
                this.resultExpr = newsqrt;
            }
            if (rightc.getValue() == 1.0) {
                this.resultExpr = left;
            } else if (rightc.getValue() == 0.5) {
                newsqrt = new MathFunctionCall(left, MathFunction.SQRT);
                newsqrt.accept((ExpressionVisitor)this);
            } else if (rightc.getValue() == 2.0) {
                this.resultExpr = new Multiplication(left, left);
            }
        }
    }

    public void visit(FloatConstant node) {
        this.resultExpr = node;
    }

    public void visit(OuterProduct node) {
        this.resultExpr = node;
    }

    public void visit(BaseVector node) {
        this.resultExpr = node;
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        Expression previousExpr = this.resultExpr;
        this.resultExpr = new Negation(this.resultExpr);
        if (previousExpr instanceof FloatConstant) {
            FloatConstant operand = (FloatConstant)previousExpr;
            this.resultExpr = operand.getValue() == 0.0 ? new FloatConstant(0.0) : new FloatConstant(-operand.getValue());
        } else if (previousExpr instanceof Negation) {
            Negation operand = (Negation)previousExpr;
            this.resultExpr = operand.getOperand();
        }
    }

    public void visit(Reverse node) {
        this.resultExpr = node;
    }

    public void visit(LogicalOr node) {
        this.resultExpr = node;
    }

    public void visit(LogicalAnd node) {
        this.resultExpr = node;
    }

    public void visit(Equality node) {
        this.resultExpr = node;
    }

    public void visit(Inequality node) {
        this.resultExpr = node;
    }

    public void visit(Relation relation) {
        this.resultExpr = relation;
    }

    public void visit(StartNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
        node.getValue().accept((ExpressionVisitor)this);
        node.setValue(this.resultExpr);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BlockEndNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
    }

    public void visit(LogicalNegation node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(FunctionArgument node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(MacroCall node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LoopNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(BreakNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Macro node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ExpressionStatement node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ColorNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

