/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.optimizations.ConstantKiller;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.HashMap;

public class ConstanKillCrawler
implements ControlFlowVisitor,
ExpressionVisitor {
    HashMap<String, Double> oneset = new HashMap();
    private AssignmentNode currAssignmentNode = null;
    private String currAssignString;
    private Expression resultExpr;
    private Expression right;
    private Expression left;
    private Expression operand;
    int replacements = 0;

    public void visit(StartNode node) {
        System.out.println("Constant Kill Run starting \n \n \n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        this.currAssignmentNode = node;
        this.currAssignString = node.getVariable().toString();
        this.resultExpr = null;
        if (node.getValue() instanceof Negation && ((Negation)node.getValue()).getOperand() instanceof FloatConstant) {
            FloatConstant f = (FloatConstant)((Negation)node.getValue()).getOperand();
            node.setValue((Expression)new FloatConstant(-f.getValue()));
        }
        if (node.getValue() instanceof FloatConstant) {
            this.oneset.put(node.getVariable().toString(), ((FloatConstant)node.getValue()).getValue());
            System.out.println("Found: " + node.getVariable().toString() + " Value: " + ((FloatConstant)node.getValue()).getValue());
            node.getSuccessor().accept((ControlFlowVisitor)this);
        } else {
            node.getValue().accept((ExpressionVisitor)this);
            node.setValue(this.resultExpr);
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BlockEndNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        System.out.println(" \n \n \n Constant Kill Run finished.....Replacements Made: " + this.replacements + "  \n \n \n \n \n");
    }

    public void visit(ColorNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Subtraction node) {
        this.handlebinary((BinaryOperation)node);
        this.resultExpr = new Subtraction(this.left, this.right);
        this.left = null;
        this.right = null;
    }

    public void visit(Addition node) {
        this.handlebinary((BinaryOperation)node);
        this.resultExpr = new Addition(this.left, this.right);
        this.left = null;
        this.right = null;
    }

    public void visit(Division node) {
        this.handlebinary((BinaryOperation)node);
        this.resultExpr = new Division(this.left, this.right);
        this.left = null;
        this.right = null;
    }

    public void handlebinary(BinaryOperation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftlocal = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightlocal = this.resultExpr;
        assert (leftlocal != null && rightlocal != null);
        if (node.getLeft() instanceof MultivectorComponent && this.oneset.containsKey(((MultivectorComponent)node.getLeft()).toString())) {
            System.out.println("Assignment: " + this.currAssignString + "  -     Replaceable Left: " + ((MultivectorComponent)node.getLeft()).toString() + "with:   " + this.oneset.get(((MultivectorComponent)node.getLeft()).toString()));
            leftlocal = new FloatConstant(this.oneset.get(((MultivectorComponent)node.getLeft()).toString()).doubleValue());
            System.out.println("Bhm");
            ++this.replacements;
        }
        if (node.getRight() instanceof MultivectorComponent && this.oneset.containsKey(((MultivectorComponent)node.getRight()).toString())) {
            System.out.println("Assignment: " + this.currAssignString + "  -     Replaceable Right: " + ((MultivectorComponent)node.getRight()).toString() + " with:  " + this.oneset.get(((MultivectorComponent)node.getRight()).toString()));
            rightlocal = new FloatConstant(this.oneset.get(((MultivectorComponent)node.getRight()).toString()).doubleValue());
            System.out.println("Bhm");
            ++this.replacements;
        }
        assert (leftlocal != null && rightlocal != null);
        this.left = leftlocal;
        this.right = rightlocal;
    }

    public void visit(Multiplication node) {
        this.handlebinary((BinaryOperation)node);
        this.resultExpr = new Multiplication(this.left, this.right);
        this.left = null;
        this.right = null;
    }

    public void visit(InnerProduct node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(MathFunctionCall node) {
        node.getOperand().accept((ExpressionVisitor)this);
        this.resultExpr = new MathFunctionCall(this.resultExpr, node.getFunction());
    }

    public void visit(Variable node) {
        this.resultExpr = node;
    }

    public void visit(MultivectorComponent node) {
        if (this.oneset.containsKey(node.toString())) {
            this.resultExpr = new FloatConstant(this.oneset.get(node.toString()).doubleValue());
            ++this.replacements;
        } else {
            this.resultExpr = node;
        }
    }

    public void visit(Exponentiation node) {
        this.handlebinary((BinaryOperation)node);
        this.resultExpr = new Exponentiation(this.left, this.right);
    }

    public void visit(FloatConstant node) {
        this.resultExpr = node;
    }

    public void visit(OuterProduct node) {
        this.resultExpr = node;
    }

    public void visit(BaseVector node) {
        this.resultExpr = node;
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        if (node.getOperand() instanceof MultivectorComponent && this.oneset.containsKey(((MultivectorComponent)node.getOperand()).toString())) {
            System.out.println("Assignment: " + this.currAssignString + "  -     Replaceable Negation Operand: " + ((MultivectorComponent)node.getOperand()).toString() + "with:    " + this.oneset.get(((MultivectorComponent)node.getOperand()).toString()));
            this.resultExpr = new FloatConstant(this.oneset.get(((MultivectorComponent)node.getOperand()).toString()).doubleValue());
            ++this.replacements;
        }
        this.resultExpr = new Negation(this.resultExpr);
    }

    public void visit(Reverse node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LogicalOr node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LogicalAnd node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Equality node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Inequality node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Relation relation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LoopNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(BreakNode node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(Macro node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ExpressionStatement node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(LogicalNegation node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(FunctionArgument node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(MacroCall node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

