/*
 * Decompiled with CFR 0.152.
 */
package wordlengthoptimization;

import datapath.graph.OperationVisitor;
import datapath.graph.operations.Absolut;
import datapath.graph.operations.Add;
import datapath.graph.operations.ArcCos;
import datapath.graph.operations.BinaryOperation;
import datapath.graph.operations.BitwidthTransmogrify;
import datapath.graph.operations.ConstantMultiplication;
import datapath.graph.operations.ConstantOperation;
import datapath.graph.operations.ConstantShift;
import datapath.graph.operations.Cos;
import datapath.graph.operations.Divide;
import datapath.graph.operations.FromOuterLoop;
import datapath.graph.operations.HWInput;
import datapath.graph.operations.HWOutput;
import datapath.graph.operations.Less;
import datapath.graph.operations.Loop;
import datapath.graph.operations.LoopEnd;
import datapath.graph.operations.LoopInit;
import datapath.graph.operations.MemWrite;
import datapath.graph.operations.Multiplication;
import datapath.graph.operations.Mux;
import datapath.graph.operations.Negation;
import datapath.graph.operations.Nop;
import datapath.graph.operations.Operation;
import datapath.graph.operations.ParentInput;
import datapath.graph.operations.Predicate;
import datapath.graph.operations.Sin;
import datapath.graph.operations.SquareRoot;
import datapath.graph.operations.Subtraction;
import datapath.graph.operations.ToInnerLoop;
import datapath.graph.operations.ToOuterLoop;
import datapath.graph.operations.TopLevelInput;
import datapath.graph.operations.TypeConversion;
import datapath.graph.operations.VariableShift;
import java.util.HashMap;

public class ComputeValueVisitor
implements OperationVisitor {
    HashMap<Operation, Double> values;

    public HashMap<Operation, Double> getValues() {
        return this.values;
    }

    public ComputeValueVisitor(HashMap<ParentInput, Double> initalValues) {
        this.values = (HashMap)initalValues.clone();
    }

    @Override
    public void visit(Operation op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(BinaryOperation op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Mux op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantOperation op) {
        this.values.put(op, Double.parseDouble(op.getValue().toString()));
    }

    @Override
    public void visit(Add op) {
        this.values.put(op, this.values.get(op.getLhs()) + this.values.get(op.getRhs()));
    }

    @Override
    public void visit(MemWrite op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Less op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(FromOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToInnerLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(HWInput op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(VariableShift op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Loop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Nop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ToOuterLoop op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Negation op) {
        Operation prev = op.getData();
        this.values.put(op, -this.values.get(prev).doubleValue());
    }

    @Override
    public void visit(LoopEnd op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(LoopInit op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(HWOutput op) {
        this.values.put(op, this.values.get(op.getData()));
    }

    @Override
    public void visit(TopLevelInput op) {
    }

    @Override
    public void visit(Multiplication op) {
        this.values.put(op, this.values.get(op.getLhs()) * this.values.get(op.getRhs()));
    }

    @Override
    public void visit(Subtraction op) {
        this.values.put(op, this.values.get(op.getLhs()) - this.values.get(op.getRhs()));
    }

    @Override
    public void visit(Divide op) {
        this.values.put(op, this.values.get(op.getLhs()) / this.values.get(op.getRhs()));
    }

    @Override
    public void visit(Absolut op) {
        this.values.put(op, Math.abs(this.values.get(op.getData())));
    }

    @Override
    public void visit(Sin op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(Cos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ArcCos op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(ConstantShift op) {
        double oldValue = this.values.get(op.getData());
        double faktor = 1.0;
        switch (op.getMode()) {
            case Left: {
                faktor = 1L << op.getShiftAmount();
                break;
            }
            case Right: 
            case SignedRight: 
            case UnsignedRight: {
                faktor = 1.0 / (double)(1L << op.getShiftAmount());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
        this.values.put(op, oldValue * faktor);
    }

    @Override
    public void visit(SquareRoot op) {
        this.values.put(op, Math.sqrt(this.values.get(op.getData())));
    }

    @Override
    public void visit(BitwidthTransmogrify op) {
        this.values.put(op, this.values.get(op.getData()));
    }

    @Override
    public void visit(Predicate op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(TypeConversion op) {
        this.values.put(op, this.values.get(op.getData()));
    }

    @Override
    public void visit(ConstantMultiplication op) {
        this.visit((Multiplication)op);
    }
}

